/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.blocking;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.blocking.BlockingChannel;
import com.palantir.dialogue.blocking.CallingThreadExecutor;
import com.palantir.dialogue.blocking.DefaultCallingThreadExecutor;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tracing.Tracers;
import com.palantir.tritium.metrics.MetricRegistries;
import com.palantir.tritium.metrics.registry.SharedTaggedMetricRegistries;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public final class BlockingChannelAdapter {
    private static final SafeLogger log = SafeLoggerFactory.get(BlockingChannelAdapter.class);
    private static final Supplier<ExecutorService> blockingExecutor = Suppliers.memoize(() -> Tracers.wrap((String)"dialogue-blocking-channel", (ExecutorService)Executors.newCachedThreadPool(MetricRegistries.instrument((TaggedMetricRegistry)SharedTaggedMetricRegistries.getSingleton(), (ThreadFactory)new ThreadFactoryBuilder().setNameFormat("dialogue-blocking-channel-%d").setDaemon(true).build(), (String)"dialogue-blocking-channel"))));

    public static Channel of(BlockingChannel blockingChannel) {
        return BlockingChannelAdapter.of(blockingChannel, blockingExecutor.get());
    }

    public static Channel of(BlockingChannel blockingChannel, ExecutorService executor) {
        return new BlockingChannelAdapterChannel(blockingChannel, executor);
    }

    private BlockingChannelAdapter() {
    }

    private static final class BlockingChannelAdapterChannel
    implements Channel {
        private final BlockingChannel delegate;
        private final ExecutorService executor;

        BlockingChannelAdapterChannel(BlockingChannel delegate, ExecutorService executor) {
            this.delegate = delegate;
            this.executor = executor;
        }

        public ListenableFuture<Response> execute(Endpoint endpoint, Request request) {
            SettableFuture settableFuture = SettableFuture.create();
            BlockingChannelAdapterTask runnable = new BlockingChannelAdapterTask(this.delegate, endpoint, request, (SettableFuture<Response>)settableFuture);
            try {
                CallingThreadExecutor callingThreadExecutor = (CallingThreadExecutor)request.attachments().getOrDefault(DefaultCallingThreadExecutor.ATTACHMENT_KEY, null);
                if (callingThreadExecutor != null) {
                    callingThreadExecutor.execute(runnable);
                } else {
                    final Future<?> future = this.executor.submit(runnable);
                    DialogueFutures.addDirectCallback((ListenableFuture)settableFuture, (FutureCallback)new FutureCallback<Response>(){

                        public void onSuccess(Response _result) {
                        }

                        public void onFailure(Throwable throwable) {
                            if (throwable instanceof CancellationException) {
                                future.cancel(true);
                            }
                        }
                    });
                }
                return settableFuture;
            }
            catch (Error | RuntimeException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }

        public String toString() {
            return "BlockingChannelAdapterChannel{delegate=" + this.delegate + ", executor=" + this.executor + "}";
        }

        static final class BlockingChannelAdapterTask
        implements Runnable {
            private final SettableFuture<Response> result;
            private final BlockingChannel delegate;
            private final Endpoint endpoint;
            private final Request request;

            BlockingChannelAdapterTask(BlockingChannel delegate, Endpoint endpoint, Request request, SettableFuture<Response> result) {
                this.result = result;
                this.delegate = delegate;
                this.endpoint = endpoint;
                this.request = request;
            }

            @Override
            public void run() {
                block4: {
                    if (this.result.isDone()) {
                        return;
                    }
                    try {
                        Response response = this.delegate.execute(this.endpoint, this.request);
                        if (!this.result.set((Object)response)) {
                            log.info("Received response, but future has already been completed", (Arg)SafeArg.of((String)"service", (Object)this.endpoint.serviceName()), (Arg)SafeArg.of((String)"endpoint", (Object)this.endpoint.endpointName()), (Arg)SafeArg.of((String)"futureCancelled", (Object)this.result.isCancelled()));
                            response.close();
                        }
                    }
                    catch (Throwable t) {
                        if (this.result.setException(t)) break block4;
                        log.info("Failed to set future exception", (Arg)SafeArg.of((String)"service", (Object)this.endpoint.serviceName()), (Arg)SafeArg.of((String)"endpoint", (Object)this.endpoint.endpointName()), t);
                    }
                }
            }

            public String toString() {
                return "BlockingChannelAdapterTask{delegate=" + this.delegate + ", endpoint=" + this.endpoint + ", request=" + this.request + "}";
            }
        }
    }
}

