/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.futures;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.futures.DialogueFutures;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class DialogueDirectAsyncCatchingFuture<T>
implements ListenableFuture<T>,
Runnable {
    private volatile ListenableFuture<T> currentFuture;
    private final ListenableFuture<T> output;

    DialogueDirectAsyncCatchingFuture(ListenableFuture<T> input, AsyncFunction<? super Throwable, T> function) {
        this.currentFuture = input;
        this.output = Futures.catchingAsync(input, Throwable.class, throwable -> {
            ListenableFuture future;
            if (input.isCancelled()) {
                return Futures.immediateCancelledFuture();
            }
            this.currentFuture = future = function.apply(throwable);
            return future;
        }, (Executor)DialogueFutures.safeDirectExecutor());
        this.output.addListener((Runnable)this, DialogueFutures.safeDirectExecutor());
    }

    public void addListener(Runnable listener, Executor executor) {
        this.output.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        ListenableFuture<T> snapshot = this.currentFuture;
        return snapshot.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.output.isCancelled();
    }

    public boolean isDone() {
        return this.output.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.output.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.output.get(timeout, unit);
    }

    @Override
    public void run() {
        this.currentFuture = this.output;
    }
}

