/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.futures;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.dialogue.futures.DialogueFutures;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class DialogueDirectAsyncTransformationFuture<I, O>
implements ListenableFuture<O>,
Runnable {
    private volatile ListenableFuture<?> currentFuture;
    private final ListenableFuture<O> output;

    DialogueDirectAsyncTransformationFuture(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        this.currentFuture = input;
        this.output = Futures.transformAsync(input, result -> {
            ListenableFuture future;
            this.currentFuture = future = function.apply(result);
            return future;
        }, (Executor)DialogueFutures.safeDirectExecutor());
        this.output.addListener((Runnable)this, DialogueFutures.safeDirectExecutor());
    }

    public void addListener(Runnable listener, Executor executor) {
        this.output.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        ListenableFuture<?> snapshot = this.currentFuture;
        return snapshot.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        ListenableFuture<?> snapshot = this.currentFuture;
        return snapshot.isCancelled();
    }

    public boolean isDone() {
        return this.output.isDone();
    }

    public O get() throws InterruptedException, ExecutionException {
        return (O)this.output.get();
    }

    public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (O)this.output.get(timeout, unit);
    }

    @Override
    public void run() {
        this.currentFuture = this.output;
    }
}

