/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.futures;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.dialogue.futures.DialogueDirectAsyncCatchingFuture;
import com.palantir.dialogue.futures.DialogueDirectAsyncTransformationFuture;
import com.palantir.dialogue.futures.DialogueDirectTransformationFuture;
import com.palantir.dialogue.futures.SafeDirectExecutor;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public final class DialogueFutures {
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        return new DialogueDirectTransformationFuture<I, O>(input, function);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
        return new DialogueDirectAsyncTransformationFuture<I, O>(input, function);
    }

    public static <T> ListenableFuture<T> catchingAllAsync(ListenableFuture<T> input, AsyncFunction<Throwable, T> function) {
        return new DialogueDirectAsyncCatchingFuture<T>(input, function);
    }

    @CanIgnoreReturnValue
    public static <T> ListenableFuture<T> addDirectCallback(ListenableFuture<T> future, FutureCallback<T> callback) {
        Futures.addCallback(future, callback, (Executor)DialogueFutures.safeDirectExecutor());
        return future;
    }

    @CanIgnoreReturnValue
    public static <T> ListenableFuture<T> addDirectListener(ListenableFuture<T> future, Runnable listener) {
        future.addListener(listener, DialogueFutures.safeDirectExecutor());
        return future;
    }

    public static Executor safeDirectExecutor() {
        return SafeDirectExecutor.INSTANCE;
    }

    public static <T> FutureCallback<T> onSuccess(final Consumer<T> onSuccess) {
        return new FutureCallback<T>(){

            public void onSuccess(T result) {
                onSuccess.accept(result);
            }

            public void onFailure(Throwable _throwable) {
            }
        };
    }

    private DialogueFutures() {
    }
}

