/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.dialogue.futures;

import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.concurrent.Executor;

enum SafeDirectExecutor implements Executor
{
    INSTANCE;

    private static final SafeLogger log;

    @Override
    public void execute(Runnable command) {
        try {
            command.run();
        }
        catch (Throwable t) {
            log.error("Task submitted to a direct executor threw an exception", t);
        }
    }

    public String toString() {
        return "SafeDirectExecutor{}";
    }

    static {
        log = SafeLoggerFactory.get(SafeDirectExecutor.class);
    }
}

