/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.dialogue.serde;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.palantir.conjure.java.dialogue.serde.BinaryEncoding;
import com.palantir.conjure.java.dialogue.serde.EmptyContainerDeserializer;
import com.palantir.conjure.java.dialogue.serde.Encoding;
import com.palantir.conjure.java.dialogue.serde.ErrorDecoder;
import com.palantir.conjure.java.dialogue.serde.LazilyInitializedEncoding;
import com.palantir.conjure.java.dialogue.serde.TracedEncoding;
import com.palantir.conjure.java.dialogue.serde.WeightedEncoding;
import com.palantir.dialogue.BinaryRequestBody;
import com.palantir.dialogue.BodySerDe;
import com.palantir.dialogue.Deserializer;
import com.palantir.dialogue.RequestBody;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.Serializer;
import com.palantir.dialogue.TypeMarker;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class ConjureBodySerDe
implements BodySerDe {
    private static final SafeLogger log = SafeLoggerFactory.get(ConjureBodySerDe.class);
    private final List<Encoding> encodingsSortedByWeight;
    private final Encoding defaultEncoding;
    private final Deserializer<InputStream> binaryInputStreamDeserializer;
    private final Deserializer<Optional<InputStream>> optionalBinaryInputStreamDeserializer;
    private final Deserializer<Void> emptyBodyDeserializer;
    private final LoadingCache<TypeMarker<?>, Serializer<?>> serializers;
    private final LoadingCache<TypeMarker<?>, Deserializer<?>> deserializers;

    ConjureBodySerDe(List<WeightedEncoding> rawEncodings, ErrorDecoder errorDecoder, EmptyContainerDeserializer emptyContainerDeserializer, CaffeineSpec cacheSpec) {
        List<WeightedEncoding> encodings = ConjureBodySerDe.decorateEncodings(rawEncodings);
        this.encodingsSortedByWeight = this.sortByWeight(encodings);
        Preconditions.checkArgument((encodings.size() > 0 ? 1 : 0) != 0, (String)"At least one Encoding is required");
        this.defaultEncoding = encodings.get(0).encoding();
        this.binaryInputStreamDeserializer = new EncodingDeserializerRegistry<InputStream>((List<Encoding>)ImmutableList.of((Object)BinaryEncoding.INSTANCE), errorDecoder, emptyContainerDeserializer, BinaryEncoding.MARKER);
        this.optionalBinaryInputStreamDeserializer = new EncodingDeserializerRegistry<Optional<InputStream>>((List<Encoding>)ImmutableList.of((Object)BinaryEncoding.INSTANCE), errorDecoder, emptyContainerDeserializer, BinaryEncoding.OPTIONAL_MARKER);
        this.emptyBodyDeserializer = new EmptyBodyDeserializer(errorDecoder);
        this.serializers = Caffeine.from((CaffeineSpec)cacheSpec).build(token -> new EncodingSerializerRegistry(this.defaultEncoding, token));
        this.deserializers = Caffeine.from((CaffeineSpec)cacheSpec).build(token -> new EncodingDeserializerRegistry(this.encodingsSortedByWeight, errorDecoder, emptyContainerDeserializer, token));
    }

    private static List<WeightedEncoding> decorateEncodings(List<WeightedEncoding> input) {
        return (List)input.stream().map(weightedEncoding -> WeightedEncoding.of(new LazilyInitializedEncoding(new TracedEncoding(weightedEncoding.encoding())), weightedEncoding.weight())).collect(ImmutableList.toImmutableList());
    }

    private ImmutableList<Encoding> sortByWeight(List<WeightedEncoding> encodings) {
        ArrayList<WeightedEncoding> mutableEncodings = new ArrayList<WeightedEncoding>(encodings);
        mutableEncodings.sort(Comparator.comparing(WeightedEncoding::weight).reversed());
        return ImmutableList.copyOf((Collection)Lists.transform(mutableEncodings, WeightedEncoding::encoding));
    }

    public <T> Serializer<T> serializer(TypeMarker<T> token) {
        return (Serializer)this.serializers.get(token);
    }

    public <T> Deserializer<T> deserializer(TypeMarker<T> token) {
        return (Deserializer)this.deserializers.get(token);
    }

    public Deserializer<Void> emptyBodyDeserializer() {
        return this.emptyBodyDeserializer;
    }

    public Deserializer<InputStream> inputStreamDeserializer() {
        return this.binaryInputStreamDeserializer;
    }

    public Deserializer<Optional<InputStream>> optionalInputStreamDeserializer() {
        return this.optionalBinaryInputStreamDeserializer;
    }

    public RequestBody serialize(final BinaryRequestBody value) {
        Preconditions.checkNotNull((Object)value, (String)"A BinaryRequestBody value is required");
        return new RequestBody(){

            public void writeTo(OutputStream output) throws IOException {
                value.write(output);
            }

            public String contentType() {
                return "application/octet-stream";
            }

            public boolean repeatable() {
                return value.repeatable();
            }

            public void close() {
                try {
                    value.close();
                }
                catch (IOException | RuntimeException e) {
                    log.warn("Failed to close BinaryRequestBody {}", (Arg)UnsafeArg.of((String)"body", (Object)value), (Throwable)e);
                }
            }
        };
    }

    private static final class EmptyBodyDeserializer
    implements Deserializer<Void> {
        private final ErrorDecoder errorDecoder;

        EmptyBodyDeserializer(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
        }

        public Void deserialize(Response response) {
            try (Response unused = response;){
                if (this.errorDecoder.isError(response)) {
                    throw this.errorDecoder.decode(response);
                }
                Void void_ = null;
                return void_;
            }
        }

        public Optional<String> accepts() {
            return Optional.empty();
        }

        public String toString() {
            return "EmptyBodyDeserializer{}";
        }
    }

    private static final class EncodingDeserializerContainer<T> {
        private final Encoding encoding;
        private final Encoding.Deserializer<T> deserializer;

        EncodingDeserializerContainer(Encoding encoding, TypeMarker<T> token) {
            this.encoding = encoding;
            this.deserializer = encoding.deserializer(token);
        }

        public String toString() {
            return "EncodingDeserializerContainer{encoding=" + this.encoding + ", deserializer=" + this.deserializer + "}";
        }
    }

    private static final class EncodingDeserializerRegistry<T>
    implements Deserializer<T> {
        private static final SafeLogger log = SafeLoggerFactory.get(EncodingDeserializerRegistry.class);
        private final ImmutableList<EncodingDeserializerContainer<T>> encodings;
        private final ErrorDecoder errorDecoder;
        private final Optional<String> acceptValue;
        private final Optional<T> emptyInstance;
        private final TypeMarker<T> token;

        EncodingDeserializerRegistry(List<Encoding> encodings, ErrorDecoder errorDecoder, EmptyContainerDeserializer empty, TypeMarker<T> token) {
            this.encodings = (ImmutableList)encodings.stream().map(encoding -> new EncodingDeserializerContainer((Encoding)encoding, token)).collect(ImmutableList.toImmutableList());
            this.errorDecoder = errorDecoder;
            this.token = token;
            this.emptyInstance = empty.tryGetEmptyInstance(token);
            this.acceptValue = Optional.of(encodings.stream().map(Encoding::getContentType).collect(Collectors.joining(", ")));
        }

        public T deserialize(Response response) {
            boolean closeResponse = true;
            try {
                if (this.errorDecoder.isError(response)) {
                    throw this.errorDecoder.decode(response);
                }
                if (response.code() == 204) {
                    if (this.emptyInstance.isPresent()) {
                        T t = this.emptyInstance.get();
                        return t;
                    }
                    throw new SafeRuntimeException("Unable to deserialize non-optional response type from 204", new Arg[]{SafeArg.of((String)"type", this.token)});
                }
                Optional contentType = response.getFirstHeader("Content-Type");
                if (!contentType.isPresent()) {
                    throw new SafeIllegalArgumentException("Response is missing Content-Type header", new Arg[]{SafeArg.of((String)"received", (Object)response.headers().keySet())});
                }
                Encoding.Deserializer<T> deserializer = this.getResponseDeserializer((String)contentType.get());
                T deserialized = deserializer.deserialize(response.body());
                closeResponse = false;
                T t = deserialized;
                return t;
            }
            catch (IOException e) {
                throw new SafeRuntimeException("Failed to deserialize response stream", (Throwable)e, new Arg[]{SafeArg.of((String)"contentType", (Object)response.getFirstHeader("Content-Type")), SafeArg.of((String)"type", this.token)});
            }
            finally {
                if (closeResponse) {
                    response.close();
                }
            }
        }

        public Optional<String> accepts() {
            return this.acceptValue;
        }

        Encoding.Deserializer<T> getResponseDeserializer(String contentType) {
            for (int i = 0; i < this.encodings.size(); ++i) {
                EncodingDeserializerContainer container = (EncodingDeserializerContainer)this.encodings.get(i);
                if (!container.encoding.supportsContentType(contentType)) continue;
                return container.deserializer;
            }
            return this.throwingDeserializer(contentType);
        }

        private Encoding.Deserializer<T> throwingDeserializer(final String contentType) {
            return new Encoding.Deserializer<T>(){

                @Override
                public T deserialize(InputStream input) {
                    try {
                        input.close();
                    }
                    catch (IOException | RuntimeException e) {
                        log.warn("Failed to close InputStream", (Throwable)e);
                    }
                    throw new SafeRuntimeException("Unsupported Content-Type", new Arg[]{SafeArg.of((String)"received", (Object)contentType), SafeArg.of((String)"supportedEncodings", encodings)});
                }
            };
        }
    }

    private static final class EncodingSerializerContainer<T> {
        private final Encoding encoding;
        private final Encoding.Serializer<T> serializer;

        EncodingSerializerContainer(Encoding encoding, TypeMarker<T> token) {
            this.encoding = encoding;
            this.serializer = encoding.serializer(token);
        }
    }

    private static final class EncodingSerializerRegistry<T>
    implements Serializer<T> {
        private final EncodingSerializerContainer<T> encoding;

        EncodingSerializerRegistry(Encoding encoding, TypeMarker<T> token) {
            this.encoding = new EncodingSerializerContainer<T>(encoding, token);
        }

        public RequestBody serialize(final T value) {
            Preconditions.checkNotNull(value, (String)"cannot serialize null value");
            return new RequestBody(){

                public void writeTo(OutputStream output) throws IOException {
                    encoding.serializer.serialize(value, output);
                }

                public String contentType() {
                    return encoding.encoding.getContentType();
                }

                public boolean repeatable() {
                    return true;
                }

                public void close() {
                }
            };
        }
    }
}

