/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.dialogue.serde;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.palantir.conjure.java.api.errors.RemoteException;
import com.palantir.conjure.java.api.errors.UnknownRemoteException;
import com.palantir.dialogue.Channel;
import com.palantir.dialogue.Clients;
import com.palantir.dialogue.Deserializer;
import com.palantir.dialogue.DialogueException;
import com.palantir.dialogue.Endpoint;
import com.palantir.dialogue.EndpointChannel;
import com.palantir.dialogue.EndpointChannelFactory;
import com.palantir.dialogue.Request;
import com.palantir.dialogue.RequestBody;
import com.palantir.dialogue.Response;
import com.palantir.dialogue.blocking.CallingThreadExecutor;
import com.palantir.dialogue.futures.DialogueFutures;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeRuntimeException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

enum DefaultClients implements Clients
{
    INSTANCE;

    private static final SafeLogger log;

    public <T> ListenableFuture<T> call(Channel channel, Endpoint endpoint, Request request, Deserializer<T> deserializer) {
        return this.call(new EndpointChannelAdapter(endpoint, channel), request, deserializer);
    }

    public <T> ListenableFuture<T> call(EndpointChannel channel, Request request, Deserializer<T> deserializer) {
        Optional accepts = deserializer.accepts();
        Request outgoingRequest = accepts.isPresent() ? DefaultClients.accepting(request, (String)accepts.get()) : request;
        ListenableFuture<Response> response = DefaultClients.closeRequestBodyOnCompletion((ListenableFuture<Response>)channel.execute(outgoingRequest), outgoingRequest);
        return DialogueFutures.transform(response, arg_0 -> deserializer.deserialize(arg_0));
    }

    public <T> T callBlocking(EndpointChannel channel, Request request, Deserializer<T> deserializer) {
        CallingThreadExecutor callingThreadExecutor = CallingThreadExecutor.useCallingThreadExecutor((Request)request);
        ListenableFuture<T> call = this.call(channel, request, deserializer);
        callingThreadExecutor.executeQueue(call);
        return this.block(call);
    }

    public EndpointChannel bind(Channel channel, Endpoint endpoint) {
        if (channel instanceof EndpointChannelFactory) {
            return ((EndpointChannelFactory)channel).endpoint(endpoint);
        }
        if (log.isDebugEnabled()) {
            log.debug("Channel of type {} does not implement EndpointChannelFactory, which is recommended for maximum performance. Falling back to lambda impl.", (Arg)SafeArg.of((String)"type", (Object)channel.getClass().getSimpleName()), (Arg)SafeArg.of((String)"serviceName", (Object)endpoint.serviceName()), (Arg)SafeArg.of((String)"endpointName", (Object)endpoint.endpointName()), (Arg)UnsafeArg.of((String)"channel", (Object)channel), (Throwable)new SafeRuntimeException("Exception for stacktrace", new Arg[0]));
        }
        return new EndpointChannelAdapter(endpoint, channel);
    }

    private static ListenableFuture<Response> closeRequestBodyOnCompletion(ListenableFuture<Response> responseFuture, Request request) {
        Optional requestBody = request.body();
        if (requestBody.isPresent()) {
            DialogueFutures.addDirectListener(responseFuture, () -> ((RequestBody)((RequestBody)requestBody.get())).close());
        }
        return responseFuture;
    }

    public <T> T block(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (!future.cancel(true)) {
                Futures.addCallback(future, (FutureCallback)CancelListener.INSTANCE, (Executor)DialogueFutures.safeDirectExecutor());
            }
            throw new DialogueException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                throw DefaultClients.newRemoteException((RemoteException)cause);
            }
            if (cause instanceof UnknownRemoteException) {
                throw DefaultClients.newUnknownRemoteException((UnknownRemoteException)cause);
            }
            if (cause instanceof RuntimeException) {
                cause.addSuppressed((Throwable)new SafeRuntimeException("Rethrown by dialogue", new Arg[0]));
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                cause.addSuppressed((Throwable)new SafeRuntimeException("Rethrown by dialogue", new Arg[0]));
                throw (Error)cause;
            }
            throw new DialogueException(cause);
        }
    }

    private static RemoteException newRemoteException(RemoteException remoteException) {
        RemoteException newException = new RemoteException(remoteException.getError(), remoteException.getStatus());
        newException.initCause((Throwable)remoteException);
        return newException;
    }

    private static UnknownRemoteException newUnknownRemoteException(UnknownRemoteException cause) {
        UnknownRemoteException newException = new UnknownRemoteException(cause.getStatus(), cause.getBody());
        newException.initCause((Throwable)cause);
        return newException;
    }

    private static Request accepting(Request original, String acceptValue) {
        Preconditions.checkNotNull((Object)acceptValue, (String)"Accept value is required");
        Preconditions.checkState((!acceptValue.isEmpty() ? 1 : 0) != 0, (String)"Accept value must not be empty");
        if (original.headerParams().containsKey((Object)"Accept")) {
            log.warn("Request {} already contains an Accept header value {}", (Arg)UnsafeArg.of((String)"request", (Object)original), (Arg)SafeArg.of((String)"existingAcceptValue", (Object)original.headerParams().get((Object)"Accept")));
            return original;
        }
        return Request.builder().from(original).putHeaderParams("Accept", acceptValue).build();
    }

    static {
        log = SafeLoggerFactory.get(DefaultClients.class);
    }

    private static final class EndpointChannelAdapter
    implements EndpointChannel {
        private final Endpoint endpoint;
        private final Channel channel;

        EndpointChannelAdapter(Endpoint endpoint, Channel channel) {
            this.endpoint = (Endpoint)Preconditions.checkNotNull((Object)endpoint, (String)"Endpoint must not be null");
            this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (String)"Channel must not be null");
        }

        public ListenableFuture<Response> execute(Request request) {
            return this.channel.execute(this.endpoint, request);
        }

        public String toString() {
            return "EndpointChannelAdapter{endpoint=" + this.endpoint + ", channel=" + this.channel + "}";
        }
    }

    static enum CancelListener implements FutureCallback<Object>
    {
        INSTANCE;


        public void onSuccess(Object result) {
            Optional resultOptional;
            if (result instanceof Closeable) {
                try {
                    ((Closeable)result).close();
                }
                catch (IOException | RuntimeException e) {
                    log.info("Failed to close result of {} after the call was canceled", (Arg)UnsafeArg.of((String)"result", (Object)result), (Throwable)e);
                }
            } else if (result instanceof Optional && (resultOptional = (Optional)result).isPresent()) {
                this.onSuccess(resultOptional.get());
            }
        }

        public void onFailure(Throwable throwable) {
            log.info("Canceled call failed", throwable);
        }
    }
}

