/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.dialogue.serde;

import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.dialogue.serde.ConjureBodySerDe;
import com.palantir.conjure.java.dialogue.serde.ConjurePlainSerDe;
import com.palantir.conjure.java.dialogue.serde.DefaultClients;
import com.palantir.conjure.java.dialogue.serde.Encoding;
import com.palantir.conjure.java.dialogue.serde.Encodings;
import com.palantir.conjure.java.dialogue.serde.ErrorDecoder;
import com.palantir.conjure.java.dialogue.serde.WeightedEncoding;
import com.palantir.dialogue.BodySerDe;
import com.palantir.dialogue.Clients;
import com.palantir.dialogue.ConjureRuntime;
import com.palantir.dialogue.PlainSerDe;
import java.util.ArrayList;
import java.util.List;

public final class DefaultConjureRuntime
implements ConjureRuntime {
    @VisibleForTesting
    static final CaffeineSpec DEFAULT_SERDE_CACHE_SPEC = CaffeineSpec.parse((String)"maximumSize=1000,expireAfterAccess=1m,weakValues");
    static final ImmutableList<WeightedEncoding> DEFAULT_ENCODINGS = ImmutableList.of((Object)WeightedEncoding.of(Encodings.json(), 0.9), (Object)WeightedEncoding.of(Encodings.smile(), 1.0), (Object)WeightedEncoding.of(Encodings.cbor(), 0.7));
    private final BodySerDe bodySerDe;

    private DefaultConjureRuntime(Builder builder) {
        this.bodySerDe = new ConjureBodySerDe((List<WeightedEncoding>)(builder.encodings.isEmpty() ? DEFAULT_ENCODINGS : builder.encodings), ErrorDecoder.INSTANCE, Encodings.emptyContainerDeserializer(), DEFAULT_SERDE_CACHE_SPEC);
    }

    public static Builder builder() {
        return new Builder();
    }

    public BodySerDe bodySerDe() {
        return this.bodySerDe;
    }

    public PlainSerDe plainSerDe() {
        return ConjurePlainSerDe.INSTANCE;
    }

    public Clients clients() {
        return DefaultClients.INSTANCE;
    }

    public static final class Builder {
        private final List<WeightedEncoding> encodings = new ArrayList<WeightedEncoding>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder encodings(Encoding value) {
            this.encodings.add(WeightedEncoding.of(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder encodings(Encoding value, double weight) {
            this.encodings.add(WeightedEncoding.of(value, weight));
            return this;
        }

        public DefaultConjureRuntime build() {
            return new DefaultConjureRuntime(this);
        }
    }
}

