/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.dialogue.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Suppliers;
import com.palantir.conjure.java.dialogue.serde.EmptyContainerDeserializer;
import com.palantir.conjure.java.dialogue.serde.Encoding;
import com.palantir.conjure.java.dialogue.serde.JacksonEmptyContainerLoader;
import com.palantir.conjure.java.serialization.ObjectMappers;
import com.palantir.dialogue.TypeMarker;
import com.palantir.logsafe.Preconditions;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class Encodings {
    private static final Supplier<ObjectMapper> JSON_MAPPER = Suppliers.memoize(() -> Encodings.configure(ObjectMappers.newClientObjectMapper()));

    private Encodings() {
    }

    public static Encoding json() {
        return new AbstractJacksonEncoding(JSON_MAPPER.get()){
            private static final String CONTENT_TYPE = "application/json";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }

            @Override
            public boolean supportsContentType(String contentType) {
                return Encodings.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    public static Encoding cbor() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newCborClientObjectMapper())){
            private static final String CONTENT_TYPE = "application/cbor";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }

            @Override
            public boolean supportsContentType(String contentType) {
                return Encodings.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    public static Encoding smile() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newSmileClientObjectMapper())){
            private static final String CONTENT_TYPE = "application/x-jackson-smile";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }

            @Override
            public boolean supportsContentType(String contentType) {
                return Encodings.matchesContentType(CONTENT_TYPE, contentType);
            }
        };
    }

    static EmptyContainerDeserializer emptyContainerDeserializer() {
        return new JacksonEmptyContainerLoader(JSON_MAPPER.get());
    }

    static boolean matchesContentType(String contentType, @Nullable String typeToCheck) {
        return typeToCheck != null && typeToCheck.startsWith(contentType);
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        return mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM});
    }

    private static abstract class AbstractJacksonEncoding
    implements Encoding {
        private final ObjectMapper mapper;

        AbstractJacksonEncoding(ObjectMapper mapper) {
            this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (String)"ObjectMapper is required");
        }

        @Override
        public final <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
            ObjectWriter writer = this.mapper.writerFor(this.mapper.constructType(type.getType()));
            return (value, output) -> writer.writeValue(output, Preconditions.checkNotNull((Object)value, (String)"cannot serialize null value"));
        }

        @Override
        public final <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
            ObjectReader reader = this.mapper.readerFor(this.mapper.constructType(type.getType()));
            return input -> {
                try (InputStream inputStream = input;){
                    Object value = reader.readValue(inputStream);
                    Object object = Preconditions.checkNotNull((Object)value, (String)"cannot deserialize a JSON null value");
                    return object;
                }
            };
        }

        public final String toString() {
            return "AbstractJacksonEncoding{" + this.getContentType() + "}";
        }
    }
}

