/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.dialogue.serde;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.common.primitives.Longs;
import com.palantir.conjure.java.api.errors.QosException;
import com.palantir.conjure.java.api.errors.RemoteException;
import com.palantir.conjure.java.api.errors.SerializableError;
import com.palantir.conjure.java.api.errors.UnknownRemoteException;
import com.palantir.conjure.java.dialogue.serde.Encodings;
import com.palantir.conjure.java.serialization.ObjectMappers;
import com.palantir.dialogue.Response;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeExceptions;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public enum ErrorDecoder {
    INSTANCE;

    private static final SafeLogger log;
    private static final ObjectMapper MAPPER;

    public boolean isError(Response response) {
        return 300 <= response.code() && response.code() <= 599;
    }

    public RuntimeException decode(Response response) {
        if (log.isDebugEnabled()) {
            log.debug("Received an error response", ErrorDecoder.diagnosticArgs(response));
        }
        RuntimeException result = this.decodeInternal(response);
        result.addSuppressed(ErrorDecoder.diagnostic(response));
        return result;
    }

    private RuntimeException decodeInternal(Response response) {
        String body;
        int code = response.code();
        switch (code) {
            case 308: {
                Optional location = response.getFirstHeader("Location");
                if (location.isPresent()) {
                    String locationHeader = (String)location.get();
                    try {
                        UnknownRemoteException remoteException = new UnknownRemoteException(code, "");
                        remoteException.initCause((Throwable)QosException.retryOther((URL)new URL(locationHeader)));
                        return remoteException;
                    }
                    catch (MalformedURLException e) {
                        log.error("Failed to parse location header for QosException.RetryOther", (Arg)UnsafeArg.of((String)"locationHeader", (Object)locationHeader), (Throwable)e);
                        break;
                    }
                }
                log.error("Retrieved HTTP status code 308 without Location header, cannot perform redirect. This appears to be a server-side protocol violation.");
                break;
            }
            case 429: {
                return (RuntimeException)response.getFirstHeader("Retry-After").map(Longs::tryParse).map(Duration::ofSeconds).map(QosException::throttle).orElseGet(QosException::throttle);
            }
            case 503: {
                return QosException.unavailable();
            }
        }
        try {
            body = ErrorDecoder.toString(response.body());
        }
        catch (IOException | NullPointerException e) {
            UnknownRemoteException exception = new UnknownRemoteException(code, "<unparseable>");
            exception.initCause((Throwable)e);
            return exception;
        }
        Optional contentType = response.getFirstHeader("Content-Type");
        if (contentType.isPresent() && Encodings.matchesContentType("application/json", (String)contentType.get())) {
            try {
                SerializableError serializableError = (SerializableError)MAPPER.readValue(body, SerializableError.class);
                return new RemoteException(serializableError, code);
            }
            catch (Exception e) {
                return new UnknownRemoteException(code, body);
            }
        }
        return new UnknownRemoteException(code, body);
    }

    private static String toString(InputStream body) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(body, StandardCharsets.UTF_8);){
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
    }

    private static ResponseDiagnostic diagnostic(Response response) {
        return new ResponseDiagnostic(ErrorDecoder.diagnosticArgs(response));
    }

    private static ImmutableList<Arg<?>> diagnosticArgs(Response response) {
        ImmutableList.Builder args = ImmutableList.builder().add((Object)SafeArg.of((String)"status", (Object)response.code()));
        ErrorDecoder.recordHeader("Server", response, args);
        ErrorDecoder.recordHeader("Content-Type", response, args);
        ErrorDecoder.recordHeader("Content-Length", response, args);
        ErrorDecoder.recordHeader("Connection", response, args);
        ErrorDecoder.recordHeader("Date", response, args);
        ErrorDecoder.recordHeader("x-envoy-response-flags", response, args);
        ErrorDecoder.recordHeader("x-envoy-response-code-details", response, args);
        ErrorDecoder.recordHeader("Response-Flags", response, args);
        ErrorDecoder.recordHeader("Response-Code-Details", response, args);
        return args.build();
    }

    private static void recordHeader(String header, Response response, ImmutableList.Builder<Arg<?>> args) {
        response.getFirstHeader(header).ifPresent(server -> args.add((Object)SafeArg.of((String)header, (Object)server)));
    }

    static {
        log = SafeLoggerFactory.get(ErrorDecoder.class);
        MAPPER = ObjectMappers.newClientObjectMapper();
    }

    private static final class ResponseDiagnostic
    extends RuntimeException
    implements SafeLoggable {
        private static final String SAFE_MESSAGE = "Response Diagnostic Information";
        private final ImmutableList<Arg<?>> args;

        ResponseDiagnostic(ImmutableList<Arg<?>> args) {
            super(SafeExceptions.renderMessage((String)SAFE_MESSAGE, (Arg[])((Arg[])args.toArray((Object[])new Arg[0]))));
            this.args = args;
        }

        public String getLogMessage() {
            return SAFE_MESSAGE;
        }

        public List<Arg<?>> getArgs() {
            return this.args;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

