/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.dialogue.serde;

import com.palantir.conjure.java.dialogue.serde.Encoding;
import com.palantir.logsafe.Preconditions;
import java.util.Objects;

final class WeightedEncoding {
    private final Encoding encoding;
    private final double weight;

    private WeightedEncoding(Encoding encoding, double weight) {
        this.encoding = (Encoding)Preconditions.checkNotNull((Object)encoding, (String)"Encoding is required");
        this.weight = weight;
        Preconditions.checkArgument((weight >= 0.0 && weight <= 1.0 ? 1 : 0) != 0, (String)"Weight must be between zero and one (inclusive)");
    }

    static WeightedEncoding of(Encoding encoding, double weight) {
        return new WeightedEncoding(encoding, weight);
    }

    static WeightedEncoding of(Encoding encoding) {
        return new WeightedEncoding(encoding, 1.0);
    }

    Encoding encoding() {
        return this.encoding;
    }

    double weight() {
        return this.weight;
    }

    public String toString() {
        return "WeightedEncoding{encoding=" + this.encoding + ", weight=" + this.weight + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        WeightedEncoding that = (WeightedEncoding)other;
        return Double.compare(that.weight, this.weight) == 0 && this.encoding.equals(that.encoding);
    }

    public int hashCode() {
        return Objects.hash(this.encoding, this.weight);
    }
}

