/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.conjure.api;

import com.palantir.gradle.conjure.api.GeneratorOptions;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.HashMap;
import java.util.Map;

public class ConjureExtension {
    public static final String EXTENSION_NAME = "conjure";
    private final GeneratorOptions typescriptOptions = new GeneratorOptions();
    private final GeneratorOptions javaOptions = new GeneratorOptions();
    private final GeneratorOptions pythonOptions = new GeneratorOptions();
    private final Map<String, GeneratorOptions> genericOptions = new HashMap<String, GeneratorOptions>();

    public final void typescript(@DelegatesTo(value=GeneratorOptions.class) Closure<GeneratorOptions> closure) {
        closure.setDelegate((Object)this.typescriptOptions);
        closure.call();
    }

    public final void java(@DelegatesTo(value=GeneratorOptions.class) Closure<GeneratorOptions> closure) {
        closure.setDelegate((Object)this.javaOptions);
        closure.call();
    }

    public final void python(@DelegatesTo(value=GeneratorOptions.class) Closure<GeneratorOptions> closure) {
        closure.setDelegate((Object)this.pythonOptions);
        closure.call();
    }

    public final void options(String generator, @DelegatesTo(value=GeneratorOptions.class) Closure<GeneratorOptions> closure) {
        closure.setDelegate((Object)this.getGenericOptions(generator));
        closure.call();
    }

    public final GeneratorOptions getTypescript() {
        return this.typescriptOptions;
    }

    public final GeneratorOptions getJava() {
        return this.javaOptions;
    }

    public final GeneratorOptions getPython() {
        return this.pythonOptions;
    }

    public final GeneratorOptions getGenericOptions(String generator) {
        return this.genericOptions.computeIfAbsent(generator, _g -> new GeneratorOptions());
    }
}

