/*
 * (c) Copyright 2019 Palantir Technologies Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.palantir.gradle.versions.internal;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.immutables.value.Value;
import org.immutables.value.Value.Parameter;

@Value.Immutable
@ImmutablesStyle
public abstract class MyModuleIdentifier implements ModuleIdentifier {
    @Override
    @Parameter
    public abstract String getGroup();

    @Override
    @Parameter
    public abstract String getName();

    @Override
    public final String toString() {
        return getGroup() + ":" + getName();
    }

    public static MyModuleIdentifier of(String group, String name) {
        return ImmutableMyModuleIdentifier.of(group, name);
    }
}
