/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.palantir.gradle.versions.FuzzyPatternResolver;
import com.palantir.gradle.versions.GradleConfigurations;
import com.palantir.gradle.versions.VersionRecommendationsExtension;
import com.palantir.gradle.versions.VersionsProps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class CheckUnusedConstraintsTask
extends DefaultTask {
    private final Property<Boolean> shouldFailWithConfigurationOnDemandMessage = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> shouldFix = this.getProject().getObjects().property(Boolean.class);
    private final RegularFileProperty propsFileProperty = this.getProject().getObjects().fileProperty();
    private final SetProperty<String> classpath = this.getProject().getObjects().setProperty(String.class);

    public CheckUnusedConstraintsTask() {
        this.shouldFailWithConfigurationOnDemandMessage.set((Object)false);
        this.shouldFix.set((Object)false);
        this.setGroup("verification");
        this.setDescription("Ensures all versions in your versions.props correspond to an actual gradle dependency");
        this.getOutputs().upToDateWhen(_task -> true);
    }

    final void setPropsFile(File propsFile) {
        this.propsFileProperty.set(propsFile);
    }

    @Input
    public final SetProperty<String> getClasspath() {
        return this.classpath;
    }

    @InputFile
    public final Property<RegularFile> getPropsFile() {
        return this.propsFileProperty;
    }

    @Input
    public final Property<Boolean> getShouldFailWithConfigurationOnDemandMessage() {
        return this.shouldFailWithConfigurationOnDemandMessage;
    }

    final void setShouldFailWithConfigurationOnDemandMessage(boolean shouldFail) {
        this.shouldFailWithConfigurationOnDemandMessage.set((Object)shouldFail);
    }

    @Input
    public final Property<Boolean> getShouldFix() {
        return this.shouldFix;
    }

    @Option(option="fix", description="Whether to apply the suggested fix to versions.props")
    public final void setShouldFix(boolean shouldFix) {
        this.shouldFix.set((Object)shouldFix);
    }

    @TaskAction
    public final void checkNoUnusedPin() {
        if (((Boolean)this.shouldFailWithConfigurationOnDemandMessage.get()).booleanValue()) {
            throw new GradleException("The gradle-consistent-versions checkUnusedConstraints task must have all projects configured to work accurately, but due to Gradle configuration-on-demand, not all projects were configured. Make your command work by including a task with no project name (such as `./gradlew build` vs. `./gradlew :build`) or use --no-configure-on-demand.");
        }
        Set artifacts = (Set)this.getClasspath().get();
        VersionsProps versionsProps = VersionsProps.loadFromFile(((RegularFile)this.getPropsFile().get()).getAsFile().toPath());
        Set<String> exactConstraints = versionsProps.getFuzzyResolver().exactMatches();
        HashSet<String> unusedConstraints = new HashSet<String>((Collection<String>)Sets.difference(exactConstraints, (Set)artifacts));
        HashSet<String> unmatchedArtifacts = new HashSet<String>((Collection<String>)Sets.difference((Set)artifacts, exactConstraints));
        for (FuzzyPatternResolver.Glob glob : versionsProps.getFuzzyResolver().globs()) {
            if (unmatchedArtifacts.removeIf(glob::matches)) continue;
            unusedConstraints.add(glob.getRawPattern());
        }
        if (unusedConstraints.isEmpty()) {
            return;
        }
        if (((Boolean)this.shouldFix.get()).booleanValue()) {
            this.getProject().getLogger().lifecycle("Removing unused pins from versions.props:\n" + unusedConstraints.stream().map(name -> String.format(" - '%s'", name)).collect(Collectors.joining("\n")));
            CheckUnusedConstraintsTask.writeVersionsProps(((RegularFile)this.getPropsFile().get()).getAsFile(), unusedConstraints);
            return;
        }
        throw new RuntimeException("There are unused pins in your versions.props: \n" + unusedConstraints + "\n\nRun ./gradlew checkUnusedConstraints --fix to remove them.");
    }

    private static void writeVersionsProps(File propsFile, Set<String> unusedConstraints) {
        List<String> lines = CheckUnusedConstraintsTask.readVersionsPropsLines(propsFile);
        try (BufferedWriter writer0 = Files.newBufferedWriter(propsFile.toPath(), StandardOpenOption.TRUNCATE_EXISTING);
             PrintWriter writer = new PrintWriter(writer0);){
            for (String line : lines) {
                if (!unusedConstraints.stream().noneMatch(line::startsWith)) continue;
                writer.println(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> readVersionsPropsLines(File propsFile) {
        List list;
        block8: {
            Stream<String> lines = Files.lines(propsFile.toPath());
            try {
                list = (List)lines.collect(ImmutableList.toImmutableList());
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading " + propsFile.toPath());
                }
            }
            lines.close();
        }
        return list;
    }

    static Stream<String> getResolvedModuleIdentifiers(Project project, VersionRecommendationsExtension extension) {
        return GradleConfigurations.getResolvableConfigurations(project).stream().filter(configuration -> !extension.shouldExcludeConfiguration(configuration.getName())).flatMap(configuration -> {
            try {
                ResolutionResult resolutionResult = configuration.getIncoming().getResolutionResult();
                return resolutionResult.getAllComponents().stream().map(ComponentResult::getId).filter(cid -> !cid.equals(resolutionResult.getRoot().getId())).filter(cid -> cid instanceof ModuleComponentIdentifier).map(mcid -> ((ModuleComponentIdentifier)mcid).getModuleIdentifier()).map(mid -> mid.getGroup() + ":" + mid.getName());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error during resolution of the dependency graph of configuration %s", configuration), e);
            }
        });
    }
}

