/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.ImmutableSet;
import com.palantir.gradle.versions.ImmutableFuzzyPatternResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
public abstract class FuzzyPatternResolver {
    protected FuzzyPatternResolver() {
    }

    abstract Map<String, String> versions();

    @Value.Derived
    public Set<String> exactMatches() {
        return (Set)this.versions().keySet().stream().filter(name -> !name.contains("*")).collect(ImmutableSet.toImmutableSet());
    }

    @Value.Derived
    protected List<Glob> globs() {
        ArrayList<Glob> cache = new ArrayList<Glob>();
        for (String name : this.versions().keySet()) {
            if (!name.contains("*")) continue;
            cache.add(Glob.compile(name));
        }
        Collections.sort(cache);
        return cache;
    }

    public final Optional<String> patternFor(String key) {
        if (this.exactMatches().contains(key)) {
            return Optional.empty();
        }
        for (Glob glob : this.globs()) {
            if (!glob.matches(key)) continue;
            return Optional.of(glob.rawPattern);
        }
        return Optional.empty();
    }

    public static Builder builder() {
        return new Builder();
    }

    protected static final class Glob
    implements Comparable<Glob> {
        private final Pattern pattern;
        private final String rawPattern;
        private final int weight;

        private Glob(Pattern pattern, String rawPattern, int weight) {
            this.pattern = pattern;
            this.rawPattern = rawPattern;
            this.weight = weight;
        }

        private static Glob compile(String glob) {
            StringBuilder patternBuilder = new StringBuilder();
            boolean first = true;
            int weight = 0;
            for (String token : glob.split("\\*", -1)) {
                if (first) {
                    first = false;
                } else {
                    patternBuilder.append(".*?");
                }
                weight += token.length();
                patternBuilder.append(Pattern.quote(token));
            }
            Pattern pattern = Pattern.compile(patternBuilder.toString());
            return new Glob(pattern, glob, weight);
        }

        String getRawPattern() {
            return this.rawPattern;
        }

        boolean matches(String key) {
            return this.pattern.matcher(key).matches();
        }

        @Override
        public int compareTo(Glob other) {
            return Integer.compare(other.weight, this.weight);
        }
    }

    public static class Builder
    extends ImmutableFuzzyPatternResolver.Builder {
    }
}

