/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.versions.FuzzyPatternResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FuzzyPatternResolver", generator="Immutables")
@Immutable
public final class ImmutableFuzzyPatternResolver
extends FuzzyPatternResolver {
    private final ImmutableMap<String, String> versions;
    private final transient Set<String> exactMatches;
    private final transient List<FuzzyPatternResolver.Glob> globs;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFuzzyPatternResolver(ImmutableMap<String, String> versions) {
        this.versions = versions;
        this.exactMatches = this.initShim.exactMatches();
        this.globs = this.initShim.globs();
        this.initShim = null;
    }

    ImmutableMap<String, String> versions() {
        return this.versions;
    }

    @Override
    public Set<String> exactMatches() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exactMatches() : this.exactMatches;
    }

    @Override
    protected List<FuzzyPatternResolver.Glob> globs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.globs() : this.globs;
    }

    public final ImmutableFuzzyPatternResolver withVersions(Map<String, ? extends String> entries) {
        if (this.versions == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableFuzzyPatternResolver((ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFuzzyPatternResolver && this.equalTo((ImmutableFuzzyPatternResolver)another);
    }

    private boolean equalTo(ImmutableFuzzyPatternResolver another) {
        return this.versions.equals(another.versions) && this.exactMatches.equals(another.exactMatches) && this.globs.equals(another.globs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.versions.hashCode();
        h += (h << 5) + this.exactMatches.hashCode();
        h += (h << 5) + this.globs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FuzzyPatternResolver").omitNullValues().add("versions", this.versions).add("exactMatches", this.exactMatches).add("globs", this.globs).toString();
    }

    public static ImmutableFuzzyPatternResolver copyOf(FuzzyPatternResolver instance) {
        if (instance instanceof ImmutableFuzzyPatternResolver) {
            return (ImmutableFuzzyPatternResolver)instance;
        }
        return new FuzzyPatternResolver.Builder().from(instance).build();
    }

    @Generated(from="FuzzyPatternResolver", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private ImmutableMap.Builder<String, String> versions = ImmutableMap.builder();

        public Builder() {
            if (!(this instanceof FuzzyPatternResolver.Builder)) {
                throw new UnsupportedOperationException("Use: new FuzzyPatternResolver.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final FuzzyPatternResolver.Builder from(FuzzyPatternResolver instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllVersions(instance.versions());
            return (FuzzyPatternResolver.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FuzzyPatternResolver.Builder putVersions(String key, String value) {
            this.versions.put((Object)key, (Object)value);
            return (FuzzyPatternResolver.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FuzzyPatternResolver.Builder putVersions(Map.Entry<String, ? extends String> entry) {
            this.versions.put(entry);
            return (FuzzyPatternResolver.Builder)this;
        }

        @CanIgnoreReturnValue
        public final FuzzyPatternResolver.Builder versions(Map<String, ? extends String> entries) {
            this.versions = ImmutableMap.builder();
            return this.putAllVersions(entries);
        }

        @CanIgnoreReturnValue
        public final FuzzyPatternResolver.Builder putAllVersions(Map<String, ? extends String> entries) {
            this.versions.putAll(entries);
            return (FuzzyPatternResolver.Builder)this;
        }

        public ImmutableFuzzyPatternResolver build() {
            return new ImmutableFuzzyPatternResolver((ImmutableMap<String, String>)this.versions.build());
        }
    }

    @Generated(from="FuzzyPatternResolver", generator="Immutables")
    private final class InitShim {
        private byte exactMatchesBuildStage = 0;
        private Set<String> exactMatches;
        private byte globsBuildStage = 0;
        private List<FuzzyPatternResolver.Glob> globs;

        private InitShim() {
        }

        Set<String> exactMatches() {
            if (this.exactMatchesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exactMatchesBuildStage == 0) {
                this.exactMatchesBuildStage = (byte)-1;
                this.exactMatches = Objects.requireNonNull(ImmutableFuzzyPatternResolver.super.exactMatches(), "exactMatches");
                this.exactMatchesBuildStage = 1;
            }
            return this.exactMatches;
        }

        List<FuzzyPatternResolver.Glob> globs() {
            if (this.globsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.globsBuildStage == 0) {
                this.globsBuildStage = (byte)-1;
                this.globs = Objects.requireNonNull(ImmutableFuzzyPatternResolver.super.globs(), "globs");
                this.globsBuildStage = 1;
            }
            return this.globs;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.exactMatchesBuildStage == -1) {
                attributes.add("exactMatches");
            }
            if (this.globsBuildStage == -1) {
                attributes.add("globs");
            }
            return "Cannot build FuzzyPatternResolver, attribute initializers form cycle " + attributes;
        }
    }
}

