/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedMapDifference;
import com.google.common.io.Files;
import com.palantir.gradle.versions.internal.MyModuleIdentifier;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockState;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class VerifyLocksTask
extends DefaultTask {
    private final File outputFile;
    private final Property<LockState> persistedLockState;
    private final Property<LockState> currentLockState;

    public VerifyLocksTask() {
        this.setGroup("verification");
        this.setDescription("Verifies that your versions.lock is up to date");
        this.outputFile = new File(this.getTemporaryDir(), "verified");
        this.persistedLockState = this.getProject().getObjects().property(LockState.class);
        this.currentLockState = this.getProject().getObjects().property(LockState.class);
    }

    @Input
    final Property<LockState> getPersistedLockState() {
        return this.persistedLockState;
    }

    @Input
    final Property<LockState> getCurrentLockState() {
        return this.currentLockState;
    }

    @OutputFile
    final File getOutputFile() {
        return this.outputFile;
    }

    @TaskAction
    public final void taskAction() throws IOException {
        this.verifyLocksForScope(LockState::productionLinesByModuleIdentifier);
        this.verifyLocksForScope(LockState::testLinesByModuleIdentifier);
        Files.touch((File)this.outputFile);
    }

    private void verifyLocksForScope(Function<LockState, SortedMap<MyModuleIdentifier, Line>> getterForScope) {
        SortedMapDifference difference = Maps.difference(getterForScope.apply((LockState)this.persistedLockState.get()), (Map)getterForScope.apply((LockState)this.currentLockState.get()));
        Set missing = difference.entriesOnlyOnLeft().keySet();
        if (!missing.isEmpty()) {
            throw new RuntimeException("Locked dependencies missing from the resolution result: " + missing + ". Please run './gradlew --write-locks'.");
        }
        Set unknown = difference.entriesOnlyOnRight().keySet();
        if (!unknown.isEmpty()) {
            throw new RuntimeException("Found dependencies that were not in the lock state: " + unknown + ". Please run './gradlew --write-locks'.");
        }
        Map differing = difference.entriesDiffering();
        if (!differing.isEmpty()) {
            throw new RuntimeException("Found dependencies whose dependents changed:\n" + VerifyLocksTask.formatDependencyDifferences(differing) + "\n\nPlease run './gradlew --write-locks'.");
        }
    }

    private static String formatDependencyDifferences(Map<MyModuleIdentifier, MapDifference.ValueDifference<Line>> differing) {
        return differing.entrySet().stream().map(diff -> String.format("-%s\n+%s", ((Line)((MapDifference.ValueDifference)diff.getValue()).leftValue()).stringRepresentation(), ((Line)((MapDifference.ValueDifference)diff.getValue()).rightValue()).stringRepresentation())).collect(Collectors.joining("\n"));
    }
}

