/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.SourceSet;

public class VersionsLockExtension {
    private final Project project;
    private final SetProperty<String> productionConfigurations;
    private final SetProperty<String> testConfigurations;
    private final ScopeConfigurer productionConfigurer;
    private final ScopeConfigurer testConfigurer;
    private final Property<Boolean> useJavaPluginDefaults;

    @Inject
    public VersionsLockExtension(Project project) {
        this.project = project;
        this.useJavaPluginDefaults = project.getObjects().property(Boolean.class).convention((Object)true);
        this.productionConfigurations = project.getObjects().setProperty(String.class).empty();
        this.testConfigurations = project.getObjects().setProperty(String.class).empty();
        this.productionConfigurer = new ScopeConfigurer(this.productionConfigurations);
        this.testConfigurer = new ScopeConfigurer(this.testConfigurations);
    }

    public final void production(Action<ScopeConfigurer> action) {
        action.execute((Object)this.productionConfigurer);
    }

    public final void test(Action<ScopeConfigurer> action) {
        action.execute((Object)this.testConfigurer);
    }

    public final void disableJavaPluginDefaults() {
        this.useJavaPluginDefaults.set((Object)false);
    }

    public final void testProject() {
        this.disableJavaPluginDefaults();
        Preconditions.checkArgument((boolean)this.project.getPluginManager().hasPlugin("java"), (String)"The java plugin must be applied to consider this a test project: %s", (Object)this.project);
        ((JavaPluginConvention)this.project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().all(this.testConfigurer::from);
    }

    final boolean isUseJavaPluginDefaults() {
        this.useJavaPluginDefaults.finalizeValue();
        return (Boolean)this.useJavaPluginDefaults.get();
    }

    final Set<String> getProductionConfigurations() {
        this.productionConfigurations.finalizeValue();
        return (Set)this.productionConfigurations.get();
    }

    final Set<String> getTestConfigurations() {
        this.testConfigurations.finalizeValue();
        return (Set)this.testConfigurations.get();
    }

    public static final class ScopeConfigurer {
        private final SetProperty<String> configurations;

        public ScopeConfigurer(SetProperty<String> configurations) {
            this.configurations = configurations;
        }

        public void from(String configuration) {
            this.configurations.add((Object)configuration);
        }

        public void from(SourceSet sourceSet) {
            this.from(sourceSet.getCompileClasspathConfigurationName());
            this.from(sourceSet.getRuntimeClasspathConfigurationName());
        }
    }
}

