/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.versions.internal.MyModuleVersionIdentifier;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MyModuleVersionIdentifier", generator="Immutables")
@Immutable
final class ImmutableMyModuleVersionIdentifier
extends MyModuleVersionIdentifier {
    private final String group;
    private final String name;
    private final String version;

    private ImmutableMyModuleVersionIdentifier(String group, String name, String version) {
        this.group = Objects.requireNonNull(group, "group");
        this.name = Objects.requireNonNull(name, "name");
        this.version = Objects.requireNonNull(version, "version");
    }

    private ImmutableMyModuleVersionIdentifier(ImmutableMyModuleVersionIdentifier original, String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.version = version;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public final ImmutableMyModuleVersionIdentifier withGroup(String value) {
        String newValue = Objects.requireNonNull(value, "group");
        if (this.group.equals(newValue)) {
            return this;
        }
        return new ImmutableMyModuleVersionIdentifier(this, newValue, this.name, this.version);
    }

    public final ImmutableMyModuleVersionIdentifier withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMyModuleVersionIdentifier(this, this.group, newValue, this.version);
    }

    public final ImmutableMyModuleVersionIdentifier withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return new ImmutableMyModuleVersionIdentifier(this, this.group, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMyModuleVersionIdentifier && this.equalTo((ImmutableMyModuleVersionIdentifier)another);
    }

    private boolean equalTo(ImmutableMyModuleVersionIdentifier another) {
        return this.group.equals(another.group) && this.name.equals(another.name) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.group.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public static MyModuleVersionIdentifier of(String group, String name, String version) {
        return new ImmutableMyModuleVersionIdentifier(group, name, version);
    }

    public static MyModuleVersionIdentifier copyOf(MyModuleVersionIdentifier instance) {
        if (instance instanceof ImmutableMyModuleVersionIdentifier) {
            return (ImmutableMyModuleVersionIdentifier)instance;
        }
        return ImmutableMyModuleVersionIdentifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MyModuleVersionIdentifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GROUP = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private long initBits = 7L;
        @Nullable
        private String group;
        @Nullable
        private String name;
        @Nullable
        private String version;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MyModuleVersionIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ModuleVersionIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            MyModuleVersionIdentifier instance;
            long bits = 0L;
            if (object instanceof MyModuleVersionIdentifier) {
                instance = (MyModuleVersionIdentifier)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.group(instance.getGroup());
                    bits |= 4L;
                }
            }
            if (object instanceof ModuleVersionIdentifier) {
                instance = (ModuleVersionIdentifier)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.version(instance.getVersion());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.group(instance.getGroup());
                    bits |= 4L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder group(String group) {
            this.group = Objects.requireNonNull(group, "group");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public MyModuleVersionIdentifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMyModuleVersionIdentifier(null, this.group, this.name, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("group");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build MyModuleVersionIdentifier, some of required attributes are not set " + attributes;
        }
    }
}

