/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.palantir.gradle.versions.VersionsLockPlugin;
import groovy.lang.GString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.CollectionProviderInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.util.GradleVersion;

final class GradleWorkarounds {
    private static final Logger log = Logging.getLogger(GradleWorkarounds.class);
    private static final GradleVersion GRADLE_VERSION_CATEGORY_AVAILABLE = GradleVersion.version((String)"5.3-rc-1");
    private static final Attribute<String> OLD_COMPONENT_CATEGORY = Attribute.of((String)"org.gradle.component.category", String.class);

    static boolean isConfiguring(ProjectState state) {
        try {
            Class<?> stateInternal = Class.forName("org.gradle.api.internal.project.ProjectStateInternal");
            Object internal = stateInternal.cast(state);
            return (Boolean)stateInternal.getDeclaredMethod("isConfiguring", new Class[0]).invoke(internal, new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.warn("Couldn't use ProjectStateInternal to determine whether project is configuring", (Throwable)e);
            return !state.getExecuted();
        }
    }

    static <T> ListProperty<T> fixListProperty(ListProperty<T> property) {
        Class<CollectionPropertyInternal> propertyInternalClass = CollectionPropertyInternal.class;
        return (ListProperty)Proxy.newProxyInstance(GradleWorkarounds.class.getClassLoader(), new Class[]{CollectionProviderInternal.class, ListProperty.class}, (_proxy, method, args) -> {
            if (method.getDeclaringClass() == CollectionProviderInternal.class) {
                if (method.getName().equals("getElementType")) {
                    return propertyInternalClass.getMethod(method.getName(), method.getParameterTypes()).invoke((Object)property, args);
                }
                if (method.getName().equals("size")) {
                    return ((List)property.get()).size();
                }
                throw new GradleException(String.format("Could not proxy method '%s' to object %s", method, property.getOrNull()));
            }
            return method.invoke((Object)property, args);
        });
    }

    static boolean isPlatform(AttributeContainer attributes) {
        if (GradleVersion.current().compareTo(GRADLE_VERSION_CATEGORY_AVAILABLE) < 0) {
            return GradleWorkarounds.isPlatformPre53(attributes);
        }
        return GradleWorkarounds.isPlatformPost53(attributes);
    }

    private static boolean isPlatformPost53(AttributeContainer attributes) {
        Category category = (Category)attributes.getAttribute(Category.CATEGORY_ATTRIBUTE);
        return category != null && "platform".equals(category.getName());
    }

    private static boolean isPlatformPre53(AttributeContainer attributes) {
        String category = (String)attributes.getAttribute(OLD_COMPONENT_CATEGORY);
        return category != null && category.equals("platform");
    }

    static boolean isFailOnVersionConflict(Configuration conf) {
        ConflictResolution conflictResolution = ((ResolutionStrategyInternal)conf.getResolutionStrategy()).getConflictResolution();
        return conflictResolution == ConflictResolution.strict;
    }

    public static void makeEvaluationDependOnSubprojectsToBeEvaluated(Project rootProject) {
        if (!rootProject.getGradle().getStartParameter().isConfigureOnDemand() || VersionsLockPlugin.shouldWriteLocks(rootProject) || !rootProject.getGradle().getStartParameter().getCurrentDir().equals(rootProject.getRootDir())) {
            rootProject.getSubprojects().forEach(subproject -> rootProject.evaluationDependsOn(subproject.getPath()));
            return;
        }
        LinkedHashSet<String> projectPathsToEval = new LinkedHashSet<String>();
        for (String taskPath : rootProject.getGradle().getStartParameter().getTaskNames()) {
            if (!taskPath.contains(":")) {
                rootProject.getSubprojects().forEach(subproject -> rootProject.evaluationDependsOn(subproject.getPath()));
                return;
            }
            Object projectPath = taskPath.substring(0, taskPath.lastIndexOf(58));
            if (!((String)projectPath).startsWith(":")) {
                projectPath = ":" + (String)projectPath;
            }
            projectPathsToEval.add((String)projectPath);
        }
        LinkedHashSet<String> alreadyVisited = new LinkedHashSet<String>();
        while (!projectPathsToEval.isEmpty()) {
            String projectPath = (String)projectPathsToEval.iterator().next();
            projectPathsToEval.remove(projectPath);
            if (alreadyVisited.contains(projectPath) || projectPath.equals(":")) continue;
            rootProject.evaluationDependsOn(projectPath);
            Project project = rootProject.project(projectPath);
            if (!project.getState().getExecuted()) {
                throw new IllegalStateException("The project has not yet been evaluated when we expect it to have been");
            }
            for (Configuration configuration : project.getConfigurations()) {
                for (Dependency dependency : configuration.getDependencies()) {
                    Project dependencyProject;
                    if (!(dependency instanceof ProjectDependency) || (dependencyProject = ((ProjectDependency)dependency).getDependencyProject()) == rootProject) continue;
                    projectPathsToEval.add(dependencyProject.getPath());
                }
            }
            for (Task task : project.getTasks()) {
                for (Object dependedOnObj : task.getDependsOn()) {
                    String dependencyProjectPath;
                    String dependedOnTaskPath;
                    if (!(dependedOnObj instanceof String) && !(dependedOnObj instanceof GString) || !(dependedOnTaskPath = dependedOnObj.toString()).contains(":") || (dependencyProjectPath = dependedOnTaskPath.substring(0, dependedOnTaskPath.lastIndexOf(58))).isEmpty()) continue;
                    projectPathsToEval.add(dependencyProjectPath);
                }
            }
            alreadyVisited.add(projectPath);
        }
    }

    private GradleWorkarounds() {
    }
}

