/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.palantir.gradle.versions.ConflictSafeLockFile;
import com.palantir.gradle.versions.DependencyConstraintCreator;
import com.palantir.gradle.versions.DirectDependencyScopes;
import com.palantir.gradle.versions.GradleComparators;
import com.palantir.gradle.versions.GradleWorkarounds;
import com.palantir.gradle.versions.ImmutableLockedConfigurations;
import com.palantir.gradle.versions.TaskNameMatcher;
import com.palantir.gradle.versions.VerifyLocksTask;
import com.palantir.gradle.versions.VersionsLockExtension;
import com.palantir.gradle.versions.WhyDependencyTask;
import com.palantir.gradle.versions.WriteVersionsLocksMarkerTask;
import com.palantir.gradle.versions.internal.MyModuleVersionIdentifier;
import com.palantir.gradle.versions.lockstate.Dependents;
import com.palantir.gradle.versions.lockstate.FullLockState;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockState;
import com.palantir.gradle.versions.lockstate.LockStates;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import netflix.nebula.dependency.recommender.RecommendationStrategies;
import netflix.nebula.dependency.recommender.provider.RecommendationProviderContainer;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyConstraintHandler;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.util.GradleVersion;
import org.immutables.value.Value;

public class VersionsLockPlugin
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(VersionsLockPlugin.class);
    static final GradleVersion MINIMUM_GRADLE_VERSION = GradleVersion.version((String)"6.1");
    static final String UNIFIED_CLASSPATH_CONFIGURATION_NAME = "unifiedClasspath";
    private static final String PLACEHOLDER_CONFIGURATION_NAME = "consistentVersionsPlaceholder";
    private static final String LOCK_CONSTRAINTS_CONFIGURATION_NAME = "lockConstraints";
    private static final String CONSISTENT_VERSIONS_PRODUCTION = "consistentVersionsProduction";
    private static final String CONSISTENT_VERSIONS_TEST = "consistentVersionsTest";
    private static final String VERSIONS_LOCK_EXTENSION = "versionsLock";
    private static final Attribute<GcvUsage> GCV_USAGE_ATTRIBUTE = Attribute.of((String)"com.palantir.consistent-versions.usage", GcvUsage.class);
    private static final String GCV_LOCKS_CAPABILITY = "gcv:locks:0";
    private static final String WRITE_VERSIONS_LOCKS_TASK = "writeVersionsLocks";
    private static final TaskNameMatcher WRITE_VERSIONS_LOCKS_TASK_NAME_MATCHER = new TaskNameMatcher("writeVersionsLocks");
    private static final String PUBLISH_LOCAL_CONSTRAINTS_PROPERTY = "com.palantir.gradle.versions.publishLocalConstraints";
    private static final Attribute<GcvScope> GCV_SCOPE_ATTRIBUTE = Attribute.of((String)"com.palantir.consistent-versions.scope", GcvScope.class);
    static final Comparator<GcvScope> GCV_SCOPE_COMPARATOR = Comparator.comparing(scope -> {
        switch (scope) {
            case PRODUCTION: {
                return 0;
            }
            case TEST: {
                return 1;
            }
        }
        throw new RuntimeException("Unexpected GcvScope: " + scope);
    });
    private final ShowStacktrace showStacktrace;
    private final Usage internalUsage;

    @Inject
    public VersionsLockPlugin(Gradle gradle, ObjectFactory objectFactory) {
        this.showStacktrace = gradle.getStartParameter().getShowStacktrace();
        this.internalUsage = (Usage)objectFactory.named(Usage.class, "consistent-versions-usage");
    }

    static Path getRootLockFile(Project project) {
        return project.file((Object)"versions.lock").toPath();
    }

    public final void apply(Project project) {
        VersionsLockPlugin.checkPreconditions(project);
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.allprojects(p -> {
            AttributesSchema attributesSchema = p.getDependencies().getAttributesSchema();
            attributesSchema.attribute(GCV_SCOPE_ATTRIBUTE);
            attributesSchema.attribute(GCV_USAGE_ATTRIBUTE);
            attributesSchema.attribute(Usage.USAGE_ATTRIBUTE, strategy -> strategy.getCompatibilityRules().add(EverythingIsCompatibleWithConsistentVersionsUsage.class));
        });
        Configuration unifiedClasspath = (Configuration)project.getConfigurations().create(UNIFIED_CLASSPATH_CONFIGURATION_NAME, conf -> {
            conf.setVisible(false).setCanBeConsumed(false);
            conf.getAttributes().attribute(GCV_USAGE_ATTRIBUTE, (Object)GcvUsage.GCV_SOURCE);
        });
        project.allprojects(subproject -> {
            subproject.getExtensions().create(VERSIONS_LOCK_EXTENSION, VersionsLockExtension.class, new Object[]{subproject});
            this.setupDependenciesToProject(project, unifiedClasspath, (Project)subproject);
        });
        Path rootLockfile = VersionsLockPlugin.getRootLockFile(project);
        Property fullLockStateProperty = project.getObjects().property(FullLockState.class);
        project.getPluginManager().apply("java-base");
        NamedDomainObjectProvider gcvLocksConfiguration = project.getConfigurations().register("gcvLocks", conf -> {
            conf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.internalUsage);
            conf.getOutgoing().capability((Object)GCV_LOCKS_CAPABILITY);
            conf.setCanBeResolved(false);
            conf.setVisible(false);
        });
        ProjectDependency locksDependency = (ProjectDependency)project.getDependencies().create((Object)project);
        locksDependency.capabilities(moduleDependencyCapabilitiesHandler -> moduleDependencyCapabilitiesHandler.requireCapabilities(new Object[]{GCV_LOCKS_CAPABILITY}));
        locksDependency.attributes(attrs -> attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.internalUsage));
        project.getTasks().register(WRITE_VERSIONS_LOCKS_TASK, WriteVersionsLocksMarkerTask.class, writeVersionsLock -> writeVersionsLock.getOutputs().upToDateWhen(_ignored -> false));
        project.afterEvaluate(p -> {
            GradleWorkarounds.makeEvaluationDependOnSubprojectsToBeEvaluated(p);
            Map<Project, LockedConfigurations> lockedConfigurations = VersionsLockPlugin.wireUpLockedConfigurationsByProject(project);
            DirectDependencyScopes directDependencyScopes = this.recursivelyCopyProjectDependencies(project, unifiedClasspath.getIncoming().getDependencies());
            StartParameter startParameter = project.getGradle().getStartParameter();
            com.google.common.base.Supplier fullLockStateSupplier = Suppliers.memoize(() -> {
                ResolutionResult resolutionResult = unifiedClasspath.getIncoming().getResolutionResult();
                if (startParameter.isConfigureOnDemand() && project.getAllprojects().stream().anyMatch(subproject -> !subproject.getState().getExecuted())) {
                    throw new GradleException("All projects must have been configured for this task to work correctly, but due to Gradle configuration-on-demand, not all projects were configured. Make your command work by including a task with no project name (such as `./gradlew build` vs. `./gradlew :build`) or use --no-configure-on-demand.");
                }
                this.failIfAnyDependenciesUnresolved(resolutionResult);
                return VersionsLockPlugin.computeLockState(resolutionResult, directDependencyScopes);
            });
            fullLockStateProperty.set(project.provider(((Supplier)fullLockStateSupplier)::get));
            if (VersionsLockPlugin.shouldWriteLocks(project)) {
                if (VersionsLockPlugin.isSkipWriteLocks(project)) {
                    log.lifecycle("Skipped writing lock state to {} because the 'gcvSkipWriteLocks' property was set", new Object[]{rootLockfile});
                } else {
                    new ConflictSafeLockFile(rootLockfile).writeLocks((FullLockState)fullLockStateSupplier.get());
                    log.lifecycle("Finished writing lock state to {}", new Object[]{rootLockfile});
                }
            } else {
                if (VersionsLockPlugin.isIgnoreLockFile(project)) {
                    log.lifecycle("Ignoring lock file for debugging because the 'ignoreLockFile' property was set");
                    return;
                }
                if (Files.notExists(rootLockfile, new LinkOption[0])) {
                    throw new GradleException(String.format("Root lock file '%s' doesn't exist, please run `./gradlew --write-locks` to initialise locks", rootLockfile));
                }
            }
            gcvLocksConfiguration.configure(conf -> conf.getDependencyConstraints().addAll(VersionsLockPlugin.constructConstraintsFromLockFile(rootLockfile, (arg_0, arg_1) -> ((DependencyConstraintHandler)project.getDependencies().getConstraints()).create(arg_0, arg_1))));
            VersionsLockPlugin.configureAllProjectsUsingConstraints(project, rootLockfile, lockedConfigurations, locksDependency);
        });
        TaskProvider verifyLocks = project.getTasks().register("verifyLocks", VerifyLocksTask.class, task -> {
            task.getCurrentLockState().set(fullLockStateProperty.map(LockStates::toLockState));
            task.getPersistedLockState().set(project.provider(() -> new ConflictSafeLockFile(rootLockfile).readLocks()));
        });
        project.getTasks().named("check").configure(check -> check.dependsOn(new Object[]{verifyLocks}));
        project.getTasks().register("why", WhyDependencyTask.class, t -> {
            t.lockfile(rootLockfile);
            t.fullLockState((Provider<FullLockState>)fullLockStateProperty);
        });
    }

    static boolean isIgnoreLockFile(Project project) {
        return project.hasProperty("ignoreLockFile");
    }

    private static boolean isSkipWriteLocks(Project project) {
        return project.hasProperty("gcvSkipWriteLocks");
    }

    private static Map<Project, LockedConfigurations> wireUpLockedConfigurationsByProject(Project rootProject) {
        return rootProject.getAllprojects().stream().collect(Collectors.toMap(Functions.identity(), subproject -> {
            if (rootProject.getGradle().getStartParameter().isConfigureOnDemand() && !subproject.getState().getExecuted()) {
                return ImmutableLockedConfigurations.builder().build();
            }
            VersionsLockExtension ext = (VersionsLockExtension)subproject.getExtensions().getByType(VersionsLockExtension.class);
            LockedConfigurations lockedConfigurations = VersionsLockPlugin.computeConfigurationsToLock(subproject, ext);
            VersionsLockPlugin.addConfigurationDependencies(subproject, subproject.getConfigurations().getByName(CONSISTENT_VERSIONS_PRODUCTION), lockedConfigurations.productionConfigurations());
            VersionsLockPlugin.addConfigurationDependencies(subproject, subproject.getConfigurations().getByName(CONSISTENT_VERSIONS_TEST), lockedConfigurations.testConfigurations());
            return lockedConfigurations;
        }));
    }

    private void setupDependenciesToProject(Project rootProject, Configuration unifiedClasspath, Project project) {
        if (rootProject != project) {
            project.getPluginManager().withPlugin("com.palantir.configuration-resolver", _plugin -> project.getTasks().named("resolveConfigurations", task -> task.mustRunAfter(new Object[]{":resolveConfigurations"})));
        }
        project.getConfigurations().register(PLACEHOLDER_CONFIGURATION_NAME, conf -> {
            conf.setVisible(false).setCanBeResolved(false);
            conf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.internalUsage);
            conf.getAttributes().attribute(GCV_USAGE_ATTRIBUTE, (Object)GcvUsage.GCV_SOURCE);
        });
        project.getConfigurations().register(CONSISTENT_VERSIONS_PRODUCTION, conf -> {
            conf.setDescription("Outgoing configuration for production dependencies meant to be used by consistent-versions");
            conf.setVisible(false);
            conf.setCanBeConsumed(true);
            conf.setCanBeResolved(false);
            conf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.internalUsage);
            conf.getOutgoing().capability(VersionsLockPlugin.capabilityFor(project, GcvScope.PRODUCTION));
        });
        project.getConfigurations().register(CONSISTENT_VERSIONS_TEST, conf -> {
            conf.setDescription("Outgoing configuration for test dependencies meant to be used by consistent-versions");
            conf.setVisible(false);
            conf.setCanBeConsumed(true);
            conf.setCanBeResolved(false);
            conf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.internalUsage);
            conf.getOutgoing().capability(VersionsLockPlugin.capabilityFor(project, GcvScope.TEST));
        });
        unifiedClasspath.getDependencies().add((Object)VersionsLockPlugin.createDependencyOnProjectWithScope(project, GcvScope.PRODUCTION));
        unifiedClasspath.getDependencies().add((Object)VersionsLockPlugin.createDependencyOnProjectWithScope(project, GcvScope.TEST));
    }

    private static Map<String, String> capabilityFor(Project project, GcvScope scope) {
        return ImmutableMap.of((Object)"group", (Object)"gcv", (Object)"name", (Object)String.format("path=%s scope=%s", project.getPath(), scope.getName()), (Object)"version", (Object)"0");
    }

    private static void addConfigurationDependencies(Project project, Configuration fromConf, Set<Configuration> toConfs) {
        toConfs.forEach(toConf -> fromConf.getDependencies().add((Object)VersionsLockPlugin.createConfigurationDependency(project, toConf)));
    }

    private static ProjectDependency createConfigurationDependency(Project project, Configuration toConfiguration) {
        return (ProjectDependency)project.getDependencies().project((Map)ImmutableMap.of((Object)"path", (Object)project.getPath(), (Object)"configuration", (Object)toConfiguration.getName()));
    }

    private static Dependency createDependencyOnProjectWithScope(Project project, GcvScope scope) {
        ProjectDependency projectDependency = (ProjectDependency)project.getDependencies().create((Object)project);
        projectDependency.capabilities(moduleDependencyCapabilitiesHandler -> moduleDependencyCapabilitiesHandler.requireCapabilities(new Object[]{VersionsLockPlugin.capabilityFor(project, scope)}));
        projectDependency.attributes(attr -> attr.attribute(GCV_SCOPE_ATTRIBUTE, (Object)scope));
        return projectDependency;
    }

    private static void checkPreconditions(Project project) {
        Preconditions.checkState((GradleVersion.current().compareTo(MINIMUM_GRADLE_VERSION) >= 0 ? 1 : 0) != 0, (String)"This plugin requires gradle >= %s", (Object)MINIMUM_GRADLE_VERSION);
        if (!project.getRootProject().equals(project)) {
            throw new GradleException("Must be applied only to root project");
        }
        LinkedHashMultimap coordinateDuplicates = LinkedHashMultimap.create();
        HashSet subprojectsLeft = new HashSet(project.getSubprojects());
        project.subprojects(arg_0 -> VersionsLockPlugin.lambda$checkPreconditions$28(project, (Multimap)coordinateDuplicates, subprojectsLeft, arg_0));
        project.subprojects(subproject -> subproject.afterEvaluate(sub -> sub.getPluginManager().withPlugin("nebula.dependency-recommender", _plugin -> {
            RecommendationProviderContainer container = (RecommendationProviderContainer)sub.getExtensions().findByType(RecommendationProviderContainer.class);
            if (container.getStrategy() == RecommendationStrategies.OverrideTransitives) {
                throw new GradleException("Must not use strategy OverrideTransitives for " + sub + ". Use this instead: dependencyRecommendations { strategy ConflictResolved }");
            }
        })));
    }

    private static void checkForDuplicatesInSubprojects(Multimap<String, Project> coordinateDuplicates) {
        ImmutableMap duplicates = ImmutableMap.copyOf((Map)Maps.filterValues((Map)coordinateDuplicates.asMap(), projects -> projects.size() > 1));
        if (!duplicates.isEmpty()) {
            throw new GradleException(String.format("All subprojects must have unique $group:$name coordinates, but found duplicates:\n%s", duplicates.entrySet().stream().map(entry -> String.format("- '%s' -> %s", entry.getKey(), Collections2.transform((Collection)((Collection)entry.getValue()), Project::getPath))).collect(Collectors.joining("\n"))));
        }
    }

    private static void ensureNoFailOnVersionConflict(Configuration conf) {
        if (GradleWorkarounds.isFailOnVersionConflict(conf)) {
            throw new GradleException("Must not use failOnVersionConflict() for " + conf);
        }
    }

    private DirectDependencyScopes recursivelyCopyProjectDependencies(Project project, DependencySet depSet) {
        Preconditions.checkState((boolean)project.getState().getExecuted(), (Object)"recursivelyCopyProjectDependenciesWithScope should be called in afterEvaluate");
        HashMap copiedConfigurationsCache = new HashMap();
        DirectDependencyScopes.Builder scopes = new DirectDependencyScopes.Builder();
        VersionsLockPlugin.findProjectDependencyWithTargetConfigurationName(depSet, CONSISTENT_VERSIONS_PRODUCTION).forEach(conf -> this.recursivelyCopyProjectDependenciesWithScope(project, conf.getDependencies(), copiedConfigurationsCache, scopes, GcvScope.PRODUCTION));
        VersionsLockPlugin.findProjectDependencyWithTargetConfigurationName(depSet, CONSISTENT_VERSIONS_TEST).forEach(conf -> this.recursivelyCopyProjectDependenciesWithScope(project, conf.getDependencies(), copiedConfigurationsCache, scopes, GcvScope.TEST));
        return scopes.build();
    }

    private static List<Configuration> findProjectDependencyWithTargetConfigurationName(DependencySet depSet, String configurationName) {
        return depSet.stream().filter(dep -> dep instanceof ProjectDependency).map(dependency -> {
            ProjectDependency projectDependency = (ProjectDependency)dependency;
            return VersionsLockPlugin.findConfigurationUsingCapabilities(projectDependency);
        }).filter(conf -> conf.getName().equals(configurationName)).collect(Collectors.toList());
    }

    private void recursivelyCopyProjectDependenciesWithScope(Project currentProject, DependencySet dependencySet, Map<Configuration, String> copiedConfigurationsCache, DirectDependencyScopes.Builder dependencyScopes, GcvScope scope) {
        dependencySet.withType(ProjectDependency.class).all(projectDependency -> {
            Project projectDep = projectDependency.getDependencyProject();
            String targetConfiguration = projectDependency.getTargetConfiguration();
            if (targetConfiguration == null) {
                return;
            }
            Configuration targetConf = VersionsLockPlugin.getTargetConfiguration(dependencySet, projectDependency);
            if (log.isDebugEnabled()) {
                log.debug("Found legacy project dependency (with target configuration): {} -> {}", (Object)dependencySet, (Object)VersionsLockPlugin.formatProjectDependency(projectDependency));
            }
            if (copiedConfigurationsCache.containsKey(targetConf)) {
                String copiedConf = (String)copiedConfigurationsCache.get(targetConf);
                log.debug("Re-using already copied target configuration for dep {} -> {}: {}", new Object[]{currentProject, targetConf, copiedConf});
                projectDependency.setTargetConfiguration(copiedConf);
                return;
            }
            VersionsLockPlugin.causeWithDependenciesActionsToRun(targetConf);
            Configuration copiedConf = targetConf.copyRecursive();
            copiedConf.setDescription(String.format("Copy of the '%s' configuration that can be resolved by com.palantir.consistent-versions without resolving the '%s' configuration itself.", targetConf.getName(), targetConf.getName()));
            copiedConfigurationsCache.put(targetConf, copiedConf.getName());
            if (log.isDebugEnabled()) {
                log.debug("Recursively copied {}'s '{}' configuration, which has\n - dependencies: {}\n - constraints: {}", new Object[]{projectDep, targetConfiguration, ImmutableList.copyOf((Collection)copiedConf.getAllDependencies()), ImmutableList.copyOf((Collection)copiedConf.getAllDependencyConstraints())});
            }
            copiedConf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)this.internalUsage);
            copiedConf.setCanBeConsumed(true);
            copiedConf.setVisible(false);
            copiedConf.getDependencies().withType(ExternalModuleDependency.class).all(externalDep -> dependencyScopes.record(externalDep.getModule(), scope));
            copiedConf.getOutgoing().capability((Object)String.format("gcv:%s-%s-%s-%s:extra", projectDep.getGroup(), projectDep.getName(), projectDep.getVersion(), copiedConf.getName()));
            projectDep.getConfigurations().add((Object)copiedConf);
            projectDependency.setTargetConfiguration(copiedConf.getName());
            this.recursivelyCopyProjectDependenciesWithScope(projectDep, copiedConf.getDependencies(), copiedConfigurationsCache, dependencyScopes, scope);
        });
    }

    private static void causeWithDependenciesActionsToRun(Configuration conf) {
        conf.getIncoming().getDependencies();
    }

    private static Configuration getTargetConfiguration(DependencySet depSet, ProjectDependency projectDependency) {
        String targetConfiguration = (String)Preconditions.checkNotNull((Object)projectDependency.getTargetConfiguration(), (String)"Expected dependency to have a targetConfiguration: %s", (Object)VersionsLockPlugin.formatProjectDependency(projectDependency));
        Configuration targetConf = projectDependency.getDependencyProject().getConfigurations().getByName(targetConfiguration);
        Preconditions.checkNotNull((Object)targetConf, (String)"Target configuration of project dependency was null: %s -> %s", (Object)depSet, (Object)projectDependency.getDependencyProject());
        return targetConf;
    }

    private static Configuration findConfigurationUsingCapabilities(ProjectDependency projectDependency) {
        Set confs = projectDependency.getDependencyProject().getConfigurations().stream().filter(conf -> conf.getOutgoing().getCapabilities().containsAll(projectDependency.getRequestedCapabilities())).collect(Collectors.toSet());
        Preconditions.checkArgument((confs.size() == 1 ? 1 : 0) != 0, (String)"Expected to only find one target configuration with capability %s but found %s with names: %s\n%s", (Object)projectDependency.getRequestedCapabilities(), (Object)confs.size(), confs, (Object)projectDependency.getDependencyProject().getConfigurations().stream().map(conf -> String.format("- %s -> %s", conf, conf.getOutgoing().getCapabilities())).collect(Collectors.joining("\n")));
        return (Configuration)Iterables.getOnlyElement(confs);
    }

    private static String formatProjectDependency(ProjectDependency dep) {
        StringBuilder builder = new StringBuilder();
        builder.append(dep.getDependencyProject());
        if (dep.getTargetConfiguration() != null) {
            builder.append(" (configuration: ");
            builder.append(dep.getTargetConfiguration());
            builder.append(")");
        }
        if (!dep.getAttributes().isEmpty()) {
            builder.append(", attributes: ");
            builder.append(dep.getAttributes().toString());
        }
        return builder.toString();
    }

    private static boolean haveSameGroupAndName(Project project, Project subproject) {
        return project.getName().equals(subproject.getName()) && project.getGroup().equals(subproject.getGroup());
    }

    private void failIfAnyDependenciesUnresolved(ResolutionResult resolutionResult) {
        List unresolved = resolutionResult.getAllDependencies().stream().filter(a -> a instanceof UnresolvedDependencyResult).map(a -> (UnresolvedDependencyResult)a).collect(Collectors.toList());
        if (!unresolved.isEmpty()) {
            throw new GradleException(String.format("Could not compute lock state from configuration '%s' due to unresolved dependencies:\n%s", UNIFIED_CLASSPATH_CONFIGURATION_NAME, unresolved.stream().map(this::formatUnresolvedDependencyResult).collect(Collectors.joining("\n"))));
        }
    }

    private static FullLockState computeLockState(ResolutionResult resolutionResult, DirectDependencyScopes directDependencyScopes) {
        HashMap scopeCache = new HashMap();
        FullLockState.Builder builder = FullLockState.builder();
        resolutionResult.getAllComponents().stream().filter(component -> component.getId() instanceof ModuleComponentIdentifier).forEach(component -> {
            GcvScope scope = VersionsLockPlugin.getScope(component, scopeCache, directDependencyScopes);
            switch (scope) {
                case PRODUCTION: {
                    builder.putProductionDeps(MyModuleVersionIdentifier.copyOf(component.getModuleVersion()), VersionsLockPlugin.extractDependents(component));
                    return;
                }
                case TEST: {
                    builder.putTestDeps(MyModuleVersionIdentifier.copyOf(component.getModuleVersion()), VersionsLockPlugin.extractDependents(component));
                    return;
                }
            }
            throw new RuntimeException(String.format("Unexpected scope for component %s: %s", new Object[]{component.getModuleVersion(), scope}));
        });
        return builder.build();
    }

    private static GcvScope getScope(ResolvedComponentResult component, Map<ResolvedComponentResult, GcvScope> scopeCache, DirectDependencyScopes directDependencyScopes) {
        Optional<GcvScope> cached = Optional.ofNullable(scopeCache.get(component));
        if (cached.isPresent()) {
            return cached.get();
        }
        HashSet<ResolvedDependencyResult> traversedComponents = new HashSet<ResolvedDependencyResult>();
        ArrayDeque stack = new ArrayDeque(component.getDependents().size());
        stack.addAll(component.getDependents());
        HashSet discoveredScopes = Sets.newHashSetWithExpectedSize((int)2);
        while (!stack.isEmpty()) {
            ResolvedDependencyResult dependent = (ResolvedDependencyResult)stack.removeFirst();
            if (dependent.isConstraint() || !(dependent.getRequested() instanceof ModuleComponentSelector) || traversedComponents.contains(dependent)) continue;
            traversedComponents.add(dependent);
            Optional<GcvScope> cachedValue = Optional.ofNullable(scopeCache.get(dependent.getFrom()));
            if (cachedValue.isPresent()) {
                discoveredScopes.add(cachedValue.get());
                continue;
            }
            ModuleIdentifier requestedModule = ((ModuleComponentSelector)dependent.getRequested()).getModuleIdentifier();
            Optional<GcvScope> maybeScope = directDependencyScopes.getScopeFor(requestedModule);
            if (dependent.getFrom().getId() instanceof ProjectComponentIdentifier && maybeScope.isPresent()) {
                discoveredScopes.add(maybeScope.get());
                continue;
            }
            stack.addAll(dependent.getFrom().getDependents());
        }
        GcvScope scope = discoveredScopes.stream().min(GCV_SCOPE_COMPARATOR).orElseThrow(() -> new RuntimeException("Couldn't determine scope for dependency: " + component));
        scopeCache.put(component, scope);
        return scope;
    }

    private static Dependents extractDependents(ResolvedComponentResult component) {
        return Dependents.of(component.getDependents().stream().collect(Collectors.groupingBy(dep -> dep.getFrom().getId(), () -> new TreeMap(GradleComparators.COMPONENT_IDENTIFIER_COMPARATOR), Collectors.mapping(dep -> VersionsLockPlugin.getRequestedVersionConstraint(dep.getRequested()), Collectors.toCollection(() -> new TreeSet<VersionConstraint>(Comparator.comparing(Object::toString)))))));
    }

    private static VersionConstraint getRequestedVersionConstraint(ComponentSelector requested) {
        if (requested instanceof ModuleComponentSelector) {
            return ((ModuleComponentSelector)requested).getVersionConstraint();
        }
        throw new RuntimeException(String.format("Expecting a ModuleComponentSelector but found a %s: %s", requested.getClass(), requested));
    }

    private String formatUnresolvedDependencyResult(UnresolvedDependencyResult result) {
        StringBuilder failures = new StringBuilder();
        for (Throwable failure = result.getFailure(); failure != null; failure = failure.getCause()) {
            failures.append("         - ");
            failures.append(failure.getMessage());
            if (this.showStacktrace == ShowStacktrace.ALWAYS_FULL) {
                failures.append("\n");
                StringWriter out = new StringWriter();
                failure.printStackTrace(new PrintWriter(out));
                Streams.stream((Iterable)Splitter.on((char)'\n').split((CharSequence)out.getBuffer())).map(line -> "           " + line + "\n").forEachOrdered(failures::append);
            }
            failures.append("\n");
        }
        return String.format(" * %s (requested: '%s' because: %s)\n      Failures:\n%s", result.getAttempted(), result.getRequested(), result.getAttemptedReason(), failures);
    }

    private static void configureAllProjectsUsingConstraints(Project rootProject, Path gradleLockfile, Map<Project, LockedConfigurations> lockedConfigurations, ProjectDependency locksDependency) {
        List<DependencyConstraint> publishableConstraints = VersionsLockPlugin.constructPublishableConstraintsFromLockFile(rootProject, gradleLockfile, (arg_0, arg_1) -> ((DependencyConstraintHandler)rootProject.getDependencies().getConstraints()).create(arg_0, arg_1));
        rootProject.allprojects(subproject -> {
            List<DependencyConstraint> localProjectConstraints = VersionsLockPlugin.constructPublishableConstraintsFromLocalProjects(subproject, (arg_0, arg_1) -> ((DependencyConstraintHandler)rootProject.getDependencies().getConstraints()).create(arg_0, arg_1));
            ImmutableList publishableConstraintsForSubproject = ImmutableList.builder().addAll(localProjectConstraints).addAll((Iterable)publishableConstraints).build();
            VersionsLockPlugin.configureUsingConstraints(subproject, locksDependency, (List<DependencyConstraint>)publishableConstraintsForSubproject, (LockedConfigurations)lockedConfigurations.get(subproject));
        });
    }

    private static void configureUsingConstraints(Project subproject, ProjectDependency locksDependency, List<DependencyConstraint> publishableConstraints, LockedConfigurations lockedConfigurations) {
        Configuration locksConfiguration = (Configuration)subproject.getConfigurations().create(LOCK_CONSTRAINTS_CONFIGURATION_NAME, locksConf -> {
            locksConf.setVisible(false);
            locksConf.setCanBeConsumed(false);
            locksConf.setCanBeResolved(false);
            locksConf.getDependencies().add((Object)locksDependency);
        });
        ImmutableSet<Configuration> configurationsToLock = lockedConfigurations.allConfigurations();
        log.info("Configuring locks for {}. Locked configurations: {}", (Object)subproject.getPath(), configurationsToLock);
        configurationsToLock.forEach(conf -> {
            conf.extendsFrom(new Configuration[]{locksConfiguration});
            VersionsLockPlugin.ensureNoFailOnVersionConflict(conf);
        });
        NamedDomainObjectProvider publishConstraints = subproject.getConfigurations().register("gcvPublishConstraints", conf -> {
            conf.setDescription("Publishable constraints from the GCV versions.lock file");
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(false);
            conf.getDependencyConstraints().addAll((Collection)publishableConstraints);
        });
        subproject.getPluginManager().withPlugin("java", _plugin -> {
            subproject.getConfigurations().named("apiElements").configure(conf -> conf.extendsFrom(new Configuration[]{(Configuration)publishConstraints.get()}));
            subproject.getConfigurations().named("runtimeElements").configure(conf -> conf.extendsFrom(new Configuration[]{(Configuration)publishConstraints.get()}));
        });
    }

    private static LockedConfigurations computeConfigurationsToLock(Project project, VersionsLockExtension ext) {
        Preconditions.checkState((boolean)project.getState().getExecuted(), (String)"computeConfigurationsToLock should be called in afterEvaluate: %s", (Object)project);
        ImmutableLockedConfigurations.Builder lockedConfigurations = ImmutableLockedConfigurations.builder();
        lockedConfigurations.addAllProductionConfigurations(Collections2.transform(ext.getProductionConfigurations(), arg_0 -> ((ConfigurationContainer)project.getConfigurations()).getByName(arg_0)));
        lockedConfigurations.addAllTestConfigurations(Collections2.transform(ext.getTestConfigurations(), arg_0 -> ((ConfigurationContainer)project.getConfigurations()).getByName(arg_0)));
        if (ext.isUseJavaPluginDefaults() && project.getPluginManager().hasPlugin("java")) {
            SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
            lockedConfigurations.addAllProductionConfigurations((Iterable<? extends Configuration>)VersionsLockPlugin.getConfigurationsForSourceSet(project, (SourceSet)sourceSets.getByName("main")));
            sourceSets.matching(sourceSet -> sourceSet.getName().toLowerCase(Locale.ROOT).endsWith("test")).forEach(sourceSet -> lockedConfigurations.addAllTestConfigurations((Iterable<? extends Configuration>)VersionsLockPlugin.getConfigurationsForSourceSet(project, sourceSet)));
        }
        ImmutableLockedConfigurations result = lockedConfigurations.build();
        log.info("Computed locked configurations for {}: {}", (Object)project, (Object)result);
        result.allConfigurations().forEach(conf -> Preconditions.checkArgument((!conf.isCanBeConsumed() && conf.isCanBeResolved() ? 1 : 0) != 0, (String)"May only lock 'sink' configurations that are resolvable and not consumable: %s", (Object)conf));
        return result;
    }

    private static ImmutableSet<Configuration> getConfigurationsForSourceSet(Project project, SourceSet sourceSet) {
        return ImmutableSet.of((Object)project.getConfigurations().getByName(sourceSet.getCompileClasspathConfigurationName()), (Object)project.getConfigurations().getByName(sourceSet.getRuntimeClasspathConfigurationName()));
    }

    private static List<DependencyConstraint> constructConstraintsFromLockFile(Path gradleLockfile, DependencyConstraintCreator constraintCreator) {
        LockState lockState = new ConflictSafeLockFile(gradleLockfile).readLocks();
        Stream locks = Stream.concat(lockState.productionLinesByModuleIdentifier().entrySet().stream(), lockState.testLinesByModuleIdentifier().entrySet().stream());
        return locks.map(e -> e.getKey() + ":" + ((Line)e.getValue()).version()).map(notation -> constraintCreator.create(notation, (Action<? super DependencyConstraint>)((Action)constraint -> {
            constraint.version(v -> {
                String version = Objects.requireNonNull(constraint.getVersion());
                v.strictly(version);
            });
            constraint.because("Locked by versions.lock");
        }))).collect(Collectors.toList());
    }

    private static List<DependencyConstraint> constructPublishableConstraintsFromLockFile(Project rootProject, Path gradleLockfile, DependencyConstraintCreator constraintCreator) {
        LockState lockState = new ConflictSafeLockFile(gradleLockfile).readLocks();
        return lockState.productionLinesByModuleIdentifier().entrySet().stream().map(e -> e.getKey() + ":" + ((Line)e.getValue()).version()).map(notation -> constraintCreator.create(notation, (Action<? super DependencyConstraint>)((Action)constraint -> {
            constraint.version(v -> {
                String version = Objects.requireNonNull(constraint.getVersion());
                v.require(version);
            });
            constraint.because("Computed from com.palantir.consistent-versions' versions.lock in " + rootProject.getName());
        }))).collect(Collectors.toList());
    }

    private static List<DependencyConstraint> constructPublishableConstraintsFromLocalProjects(Project currentProject, DependencyConstraintCreator constraintCreator) {
        if (VersionsLockPlugin.publishLocalConstraints(currentProject)) {
            return currentProject.getRootProject().getAllprojects().stream().filter(project -> !currentProject.equals(project)).filter(VersionsLockPlugin::isJavaLibrary).map(libraryProject -> constraintCreator.create(libraryProject, (Action<? super DependencyConstraint>)((Action)constraint -> constraint.because("Library published from the same project: " + currentProject.getRootProject().getName())))).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    private static boolean publishLocalConstraints(Project project) {
        return project.hasProperty(PUBLISH_LOCAL_CONSTRAINTS_PROPERTY) && "true".equals(project.property(PUBLISH_LOCAL_CONSTRAINTS_PROPERTY));
    }

    private static boolean isJavaLibrary(Project project) {
        if (project.getPluginManager().hasPlugin("nebula.maven-publish")) {
            log.debug("Project '{}' is considered a library because the 'nebula.maven-publish' plugin is applied", (Object)project.getDisplayName());
            return true;
        }
        PublishingExtension publishing = (PublishingExtension)project.getExtensions().findByType(PublishingExtension.class);
        if (publishing == null) {
            log.debug("Project '{}' is considered a distribution, not a library, because it doesn't define any publishing extensions", (Object)project.getDisplayName());
            return false;
        }
        ImmutableList jarPublications = (ImmutableList)publishing.getPublications().stream().filter(pub -> VersionsLockPlugin.isLibraryPublication(project, pub)).map(Named::getName).collect(ImmutableList.toImmutableList());
        if (jarPublications.isEmpty()) {
            log.debug("Project '{}' is not considered a library because it does not publish jars", (Object)project.getDisplayName());
            return false;
        }
        log.debug("Project '{}' is considered a library because it publishes jars: {}", (Object)project.getDisplayName(), (Object)jarPublications);
        return true;
    }

    private static boolean isLibraryPublication(Project project, Publication publication) {
        if (publication instanceof MavenPublication) {
            MavenPublication mavenPublication = (MavenPublication)publication;
            return mavenPublication.getArtifacts().stream().anyMatch(artifact -> "jar".equals(artifact.getExtension()));
        }
        if (publication instanceof IvyPublication) {
            IvyPublication ivyPublication = (IvyPublication)publication;
            return ivyPublication.getArtifacts().stream().anyMatch(artifact -> "jar".equals(artifact.getExtension()));
        }
        log.warn("Unknown publication '{}' of type '{}'. Assuming project {} is a library", new Object[]{publication, publication.getClass().getName(), project.getName()});
        return true;
    }

    public static boolean shouldWriteLocks(Project project) {
        StartParameter startParameter = project.getGradle().getStartParameter();
        return startParameter.isWriteDependencyLocks() || WRITE_VERSIONS_LOCKS_TASK_NAME_MATCHER.matchesAny(startParameter.getTaskNames());
    }

    private static /* synthetic */ void lambda$checkPreconditions$28(Project project, Multimap coordinateDuplicates, Set subprojectsLeft, Project subproject) {
        subproject.afterEvaluate(sub -> {
            if (VersionsLockPlugin.haveSameGroupAndName(project, sub)) {
                throw new GradleException(String.format("This plugin doesn't work if the root project shares both group and name with a subproject. Consider adding the following to settings.gradle:\nrootProject.name = '%s-root'", project.getName()));
            }
            String coordinate = String.format("%s:%s", subproject.getGroup(), subproject.getName());
            coordinateDuplicates.put((Object)coordinate, (Object)subproject);
            subprojectsLeft.remove(subproject);
            if (subprojectsLeft.isEmpty()) {
                VersionsLockPlugin.checkForDuplicatesInSubprojects((Multimap<String, Project>)coordinateDuplicates);
            }
        });
    }

    @Value.Immutable
    static interface LockedConfigurations {
        public Set<Configuration> productionConfigurations();

        public Set<Configuration> testConfigurations();

        @Value.Auxiliary
        default public ImmutableSet<Configuration> allConfigurations() {
            return ImmutableSet.copyOf((Iterable)Iterables.concat(this.productionConfigurations(), this.testConfigurations()));
        }
    }

    static class EverythingIsCompatibleWithConsistentVersionsUsage
    implements AttributeCompatibilityRule<Usage> {
        EverythingIsCompatibleWithConsistentVersionsUsage() {
        }

        public void execute(CompatibilityCheckDetails<Usage> details) {
            if ("consistent-versions-usage".equals(((Usage)details.getProducerValue()).getName()) || "consistent-versions-usage".equals(((Usage)details.getConsumerValue()).getName())) {
                details.compatible();
            }
        }
    }

    public static enum GcvScope implements Named
    {
        PRODUCTION,
        TEST;


        public String getName() {
            return this.name();
        }
    }

    public static enum GcvUsage implements Named
    {
        GCV_SOURCE;


        public String getName() {
            return this.name();
        }
    }
}

