/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.palantir.gradle.versions.ConflictSafeLockFile;
import com.palantir.gradle.versions.internal.MyModuleVersionIdentifier;
import com.palantir.gradle.versions.lockstate.Dependents;
import com.palantir.gradle.versions.lockstate.FullLockState;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockStates;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class WhyDependencyTask
extends DefaultTask {
    private final Property<String> hashOption = this.getProject().getObjects().property(String.class);
    private final Property<FullLockState> fullLockState = this.getProject().getObjects().property(FullLockState.class);
    private Path lockfile;

    public WhyDependencyTask() {
        this.setGroup("Help");
        this.setDescription("Explains what a specific hash in versions.lock means");
    }

    @Option(option="hash", description="Hash from versions.lock to explain")
    public final void setHashOption(String string) {
        this.hashOption.set((Object)string);
    }

    public final void lockfile(Path path) {
        this.lockfile = path;
    }

    public final void fullLockState(Provider<FullLockState> provider) {
        this.fullLockState.set(provider);
    }

    @TaskAction
    public final void taskAction() {
        Multimap lineByHash = (Multimap)new ConflictSafeLockFile(this.lockfile).readLocks().allLines().stream().collect(Multimaps.toMultimap(Line::dependentsHash, Function.identity(), HashMultimap::create));
        if (!this.hashOption.isPresent()) {
            Optional<String> example = lineByHash.keySet().stream().map(h -> ", e.g. './gradlew why --hash " + h + "'").findFirst();
            throw new RuntimeException("./gradlew why requires a '--hash <hash>' from versions.lock" + example.orElse(""));
        }
        LinkedHashSet hashes = new LinkedHashSet(Splitter.on((String)",").splitToList((CharSequence)this.hashOption.get()));
        for (String hash : hashes) {
            lineByHash.get((Object)hash).forEach(line -> {
                MyModuleVersionIdentifier key = MyModuleVersionIdentifier.of(line.group(), line.name(), line.version());
                Optional<Dependents> entry = Stream.of(((FullLockState)this.fullLockState.get()).productionDeps(), ((FullLockState)this.fullLockState.get()).testDeps()).map(state -> (Dependents)state.get(key)).filter(Objects::nonNull).findFirst();
                Dependents dependents = entry.orElseThrow(() -> new NullPointerException("Unable to find group/name in fullLockState"));
                this.getLogger().lifecycle("{}", new Object[]{key});
                LockStates.prettyPrintConstraints(dependents).forEach(pretty -> this.getLogger().lifecycle("\t{}", new Object[]{pretty}));
                this.getLogger().lifecycle("");
            });
        }
    }
}

