/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.lockstate;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.palantir.gradle.versions.internal.MyModuleVersionIdentifier;
import com.palantir.gradle.versions.lockstate.Dependents;
import com.palantir.gradle.versions.lockstate.FullLockState;
import com.palantir.gradle.versions.lockstate.ImmutableLine;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockState;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LockStates {
    private static final Logger log = LoggerFactory.getLogger(LockStates.class);
    private static final Pattern SINGLE_VERSION_RANGE = Pattern.compile("\\[[^,]+\\]");

    private LockStates() {
    }

    public static LockState toLockState(FullLockState fullLockState) {
        return LockState.from(LockStates.computeLines(fullLockState.productionDeps()), LockStates.computeLines(fullLockState.testDeps()));
    }

    public static Stream<Line> computeLines(Map<MyModuleVersionIdentifier, Dependents> deps) {
        return deps.entrySet().stream().map(entry -> LockStates.componentWithDependentsToLine((ModuleVersionIdentifier)entry.getKey(), (Dependents)entry.getValue()));
    }

    private static Line componentWithDependentsToLine(ModuleVersionIdentifier component, Dependents dependents) {
        List<String> all = LockStates.prettyPrintConstraints(dependents);
        Hasher hasher = Hashing.adler32().newHasher();
        all.forEach(item -> hasher.putString((CharSequence)item, StandardCharsets.UTF_8));
        HashCode hash = hasher.hash();
        ImmutableLine line = ImmutableLine.of(component.getGroup(), component.getName(), component.getVersion(), all.size(), hash.toString());
        log.info("{}: {}", (Object)line.stringRepresentation(), all);
        return line;
    }

    public static List<String> prettyPrintConstraints(Dependents dependents) {
        Stream constraintEntries = Streams.concat((Stream[])new Stream[]{dependents.projectConstraints().isEmpty() ? Stream.empty() : Stream.of(Maps.immutableEntry((Object)"projects", dependents.projectConstraints())), dependents.nonProjectConstraints().entrySet().stream().map(e -> Maps.immutableEntry((Object)LockStates.formatComponentIdentifier((ComponentIdentifier)e.getKey()), (Object)((Collection)e.getValue())))});
        return constraintEntries.map(e -> {
            List constraintsStr = ((Collection)e.getValue()).stream().map(LockStates::versionConstraintToString).filter(string -> !string.isEmpty()).collect(Collectors.toList());
            if (constraintsStr.isEmpty()) {
                return Optional.empty();
            }
            if (constraintsStr.size() == 1) {
                return Optional.of((String)e.getKey() + " -> " + (String)constraintsStr.get(0));
            }
            return Optional.of((String)e.getKey() + " -> " + constraintsStr.stream().collect(Collectors.joining(", ", "{", "}")));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static String versionConstraintToString(VersionConstraint versionConstraint) {
        String constraintString = versionConstraint.toString();
        if (SINGLE_VERSION_RANGE.matcher(constraintString).matches()) {
            return constraintString.substring(1, constraintString.length() - 1);
        }
        return constraintString;
    }

    private static String formatComponentIdentifier(ComponentIdentifier id) {
        if (id instanceof ModuleComponentIdentifier) {
            return ((ModuleComponentIdentifier)id).getModuleIdentifier().toString();
        }
        return id.getDisplayName();
    }
}

