/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.palantir.gradle.failurereports.exceptions.ExceptionWithSuggestion;
import com.palantir.gradle.versions.ConflictSafeLockFile;
import com.palantir.gradle.versions.VersionsProps;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockState;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public abstract class CheckOverbroadConstraints
extends DefaultTask {
    @Input
    @Option(option="fix", description="Whether to apply the suggested fix to versions.props")
    public abstract Property<Boolean> getShouldFix();

    @InputFile
    public abstract RegularFileProperty getPropsFile();

    @InputFile
    public abstract RegularFileProperty getLockFile();

    public CheckOverbroadConstraints() {
        this.getShouldFix().set((Object)false);
        this.setGroup("verification");
        this.setDescription("Ensures matched versions in your versions.lock are pinned to avoid wasted dependency resolution.");
        this.getOutputs().upToDateWhen(_task -> false);
    }

    @TaskAction
    public final void checkOverbroadConstraints() {
        VersionsProps versionsProps = VersionsProps.loadFromFile(((RegularFile)this.getPropsFile().get()).getAsFile().toPath());
        LockState lockState = new ConflictSafeLockFile(((RegularFile)this.getLockFile().get()).getAsFile().toPath()).readLocks();
        this.checkOverbroadConstraints(versionsProps, lockState);
    }

    private void checkOverbroadConstraints(VersionsProps versionsProps, LockState lockState) {
        Map<String, List<String>> oldToNewLines = CheckOverbroadConstraints.determineNewLines(versionsProps, lockState);
        List newLines = oldToNewLines.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        newLines.removeIf(line -> oldToNewLines.keySet().stream().anyMatch(line::startsWith));
        if (newLines.isEmpty()) {
            return;
        }
        if (((Boolean)this.getShouldFix().get()).booleanValue()) {
            this.getLogger().lifecycle("Adding pins to versions.props:\n" + String.join((CharSequence)"\n", newLines));
            CheckOverbroadConstraints.writeVersionsProps(((RegularFile)this.getPropsFile().get()).getAsFile(), oldToNewLines);
            return;
        }
        throw new ExceptionWithSuggestion(String.join((CharSequence)"\n", "Over-broad version constraints found in versions.props.", "Over-broad constraints often arise due to wildcards in versions.props", "which apply to more dependencies than they should, this can lead to slow builds.", "The following additional pins are recommended:", String.join((CharSequence)"\n", newLines), "", "Run ./gradlew checkOverbroadConstraints --fix to add them.", "See https://github.com/palantir/gradle-consistent-versions?tab=readme-ov-file#gradlew-checkoverbroadconstraints for details"), "./gradlew checkOverbroadConstraints --fix");
    }

    @VisibleForTesting
    static Map<String, List<String>> determineNewLines(VersionsProps versionsProps, LockState lockState) {
        Map<String, Line> lineByArtifact = lockState.allLines().stream().collect(Collectors.toMap(line -> line.identifier().toString(), line -> line));
        Set<String> exactConstraints = versionsProps.getFuzzyResolver().exactMatches();
        HashSet unmatchedArtifacts = new HashSet(Sets.difference(lineByArtifact.keySet(), exactConstraints));
        HashMap<String, List<String>> newLinesMap = new HashMap<String, List<String>>();
        versionsProps.getFuzzyResolver().globs().forEach(glob -> {
            Set<String> matchedArtifacts = unmatchedArtifacts.stream().filter(glob::matches).collect(Collectors.toSet());
            if (!matchedArtifacts.isEmpty()) {
                List<String> newPins = CheckOverbroadConstraints.computeNewLines(matchedArtifacts, lineByArtifact);
                newLinesMap.put(glob.getRawPattern(), newPins);
                unmatchedArtifacts.removeAll(matchedArtifacts);
            }
        });
        newLinesMap.replaceAll((key, lines) -> CheckOverbroadConstraints.removeMostCommonPins(versionsProps, key, lines));
        return newLinesMap;
    }

    private static List<String> computeNewLines(Set<String> artifacts, Map<String, Line> lineByArtifact) {
        long uniqueVersionCount = artifacts.stream().map(lineByArtifact::get).map(Line::version).filter(Objects::nonNull).distinct().count();
        if (uniqueVersionCount <= 1L) {
            return Collections.emptyList();
        }
        return artifacts.stream().map(lineByArtifact::get).map(line -> CheckOverbroadConstraints.makeUniqueWildcard(line, artifacts.stream().map(lineByArtifact::get).collect(Collectors.toList()))).distinct().sorted().collect(Collectors.toList());
    }

    private static List<String> removeMostCommonPins(VersionsProps versionsProps, String originalPin, List<String> newPins) {
        Map<String, Long> versionCounts = newPins.stream().map(line -> ((String)Iterables.get((Iterable)Splitter.on((char)'=').split((CharSequence)line), (int)1)).trim()).filter(version -> !version.isEmpty()).collect(Collectors.groupingBy(version -> version, Collectors.counting()));
        if (versionCounts.isEmpty()) {
            return newPins;
        }
        long maxCount = versionCounts.values().stream().mapToLong(Long::longValue).max().orElse(0L);
        long numMax = versionCounts.values().stream().filter(count -> count == maxCount).count();
        if (numMax > 1L) {
            return newPins;
        }
        Optional<String> mostCommonVersion = versionCounts.entrySet().stream().filter(entry -> (Long)entry.getValue() == maxCount).map(Map.Entry::getKey).findFirst();
        if (mostCommonVersion.isEmpty()) {
            return newPins;
        }
        return ((StreamEx)StreamEx.of(newPins).remove(line -> {
            List parts = Splitter.on((char)'=').trimResults().omitEmptyStrings().limit(2).splitToList((CharSequence)line);
            return parts.size() > 1 && ((String)parts.get(1)).equals(mostCommonVersion.get());
        })).prepend((Object)(originalPin + " = " + versionsProps.getFuzzyResolver().versions().get(originalPin))).toList();
    }

    public static String makeUniqueWildcard(Line input, List<Line> lines) {
        Set linesWithVersionDifferentFromInput = lines.stream().filter(line -> !line.version().equals(input.version())).map(line -> line.identifier().toString()).collect(Collectors.toSet());
        String lineIdentifier = input.identifier().toString();
        String minimalLineIdentifier = IntStream.rangeClosed(1, lineIdentifier.length()).filter(i -> CheckOverbroadConstraints.isAcceptablePrefixEnd(i, lineIdentifier)).mapToObj(i -> lineIdentifier.substring(0, i)).filter(prefix -> prefix.contains(":")).filter(prefix -> linesWithVersionDifferentFromInput.stream().noneMatch(s -> s.startsWith((String)prefix))).findFirst().orElse(lineIdentifier);
        if (minimalLineIdentifier.equals(lineIdentifier)) {
            return String.format("%s = %s", input.identifier(), input.version());
        }
        return String.format("%s = %s", minimalLineIdentifier + "*", input.version());
    }

    private static boolean isAcceptablePrefixEnd(int index, String target) {
        if (index <= 0 || index > target.length()) {
            return false;
        }
        if (index == target.length()) {
            return true;
        }
        if (target.charAt(index - 1) == ':') {
            return true;
        }
        return !Character.isLetterOrDigit(target.charAt(index));
    }

    private static void writeVersionsProps(File propsFile, Map<String, List<String>> oldToNewLines) {
        List<String> existingLines = CheckOverbroadConstraints.readVersionsPropsLines(propsFile);
        List<String> updatedLines = CheckOverbroadConstraints.generateUpdatedPropsLines(oldToNewLines, existingLines);
        String content = String.join((CharSequence)System.lineSeparator(), updatedLines);
        try {
            Files.writeString(propsFile.toPath(), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    static List<String> generateUpdatedPropsLines(Map<String, List<String>> oldToNewLines, List<String> existingLines) {
        ArrayList<String> updatedLines = new ArrayList<String>();
        block0: for (String line : existingLines) {
            updatedLines.add(line);
            for (Map.Entry<String, List<String>> entry : oldToNewLines.entrySet()) {
                String oldLinePrefix = entry.getKey();
                if (!line.startsWith(oldLinePrefix)) continue;
                List<String> newLines = entry.getValue();
                if (newLines == null || newLines.isEmpty()) continue block0;
                updatedLines.addAll(newLines);
                updatedLines.remove(line);
                continue block0;
            }
        }
        return updatedLines;
    }

    private static List<String> readVersionsPropsLines(File propsFile) {
        try {
            String content = Files.readString(propsFile.toPath());
            return Splitter.on((String)"\n").splitToList((CharSequence)content);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + propsFile.toPath(), e);
        }
    }
}

