/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.palantir.gradle.versions.Validators;
import com.palantir.gradle.versions.lockstate.FullLockState;
import com.palantir.gradle.versions.lockstate.ImmutableLine;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockState;
import com.palantir.gradle.versions.lockstate.LockStates;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;

final class ConflictSafeLockFile {
    private static final String HEADER_COMMENT = "# Run ./gradlew writeVersionsLocks to regenerate this file";
    private static final Pattern LINE_PATTERN = Pattern.compile("(?<group>[^(:]+):(?<artifact>[^(:]+):(?<version>[^(:\\s]+)\\s+\\((?<num>\\d+) constraints: (?<hash>\\w+)\\)");
    private static final String TEST_DEPENDENCIES_MARKER = "[Test dependencies]";
    private final Path lockfile;

    ConflictSafeLockFile(Path lockfile) {
        this.lockfile = lockfile;
    }

    public LockState readLocks() {
        LockState lockState;
        block10: {
            Stream<String> linesStream = Files.lines(this.lockfile);
            try {
                Stream<String> testDeps;
                Stream<String> productionDeps;
                List lines = linesStream.filter(line -> !line.trim().startsWith("#")).collect(Collectors.toList());
                int testDependenciesPosition = lines.indexOf(TEST_DEPENDENCIES_MARKER);
                if (testDependenciesPosition >= 0) {
                    productionDeps = lines.subList(0, testDependenciesPosition - 1).stream();
                    testDeps = lines.subList(testDependenciesPosition + 1, lines.size()).stream();
                } else {
                    productionDeps = lines.stream().filter(line -> !line.trim().startsWith("#"));
                    testDeps = Stream.empty();
                }
                lockState = LockState.from(this.parseLines(productionDeps), this.parseLines(testDeps));
                if (linesStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (linesStream != null) {
                        try {
                            linesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GradleException(String.format("Couldn't load versions from palantir dependency lock file: %s", this.lockfile), (Throwable)e);
                }
            }
            linesStream.close();
        }
        return lockState;
    }

    public Stream<Line> parseLines(Stream<String> stringStream) {
        return stringStream.map(line -> {
            Matcher matcher = LINE_PATTERN.matcher((CharSequence)line);
            Validators.checkResultOrThrow(matcher.matches(), String.format("Found unparseable line in dependency lock file '%s': %s", this.lockfile, line), this.lockfile);
            return matcher;
        }).map(matcher -> ImmutableLine.of(matcher.group("group"), matcher.group("artifact"), matcher.group("version"), Integer.parseInt(matcher.group("num")), matcher.group("hash")));
    }

    public void writeLocks(FullLockState fullLockState) {
        LockState lockState = LockStates.toLockState(fullLockState);
        try (BufferedWriter writer = Files.newBufferedWriter(this.lockfile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.append(HEADER_COMMENT);
            writer.newLine();
            lockState.productionLinesByModuleIdentifier().values().forEach(line -> ConflictSafeLockFile.writeLine(line, writer));
            if (!lockState.testLinesByModuleIdentifier().isEmpty()) {
                writer.newLine();
                writer.write(TEST_DEPENDENCIES_MARKER);
                writer.newLine();
                lockState.testLinesByModuleIdentifier().values().forEach(line -> ConflictSafeLockFile.writeLine(line, writer));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write lock file: " + this.lockfile, e);
        }
    }

    private static void writeLine(Line line, BufferedWriter writer) {
        try {
            writer.append(line.stringRepresentation());
            writer.newLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed writing line", e);
        }
    }
}

