/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.collect.ImmutableMap;
import com.palantir.gradle.versions.VersionsLockPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.gradle.api.artifacts.ModuleIdentifier;

public final class DirectDependencyScopes {
    private final ImmutableMap<ModuleIdentifier, VersionsLockPlugin.GcvScope> map;

    private DirectDependencyScopes(Map<ModuleIdentifier, VersionsLockPlugin.GcvScope> map) {
        this.map = ImmutableMap.copyOf(map);
    }

    public Optional<VersionsLockPlugin.GcvScope> getScopeFor(ModuleIdentifier moduleIdentifier) {
        return Optional.ofNullable((VersionsLockPlugin.GcvScope)((Object)this.map.get((Object)moduleIdentifier)));
    }

    public static final class Builder {
        private final Map<ModuleIdentifier, VersionsLockPlugin.GcvScope> map = new HashMap<ModuleIdentifier, VersionsLockPlugin.GcvScope>();

        public DirectDependencyScopes build() {
            return new DirectDependencyScopes(this.map);
        }

        public void record(ModuleIdentifier module, VersionsLockPlugin.GcvScope scope) {
            this.map.compute(module, (_key, oldScope) -> oldScope != null ? Stream.of(oldScope, scope).min(VersionsLockPlugin.GCV_SCOPE_COMPARATOR).get() : scope);
        }
    }
}

