/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.palantir.gradle.versions.ImmutableRepositories;
import com.palantir.gradle.versions.ImmutableRepositoryConfig;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.immutables.value.Value;

public abstract class GenerateMavenRepositoriesTask
extends DefaultTask {
    private static final ObjectMapper XML_MAPPER = new XmlMapper((XMLInputFactory)new WstxInputFactory(), (XMLOutputFactory)new WstxOutputFactory()).registerModule((Module)new GuavaModule());
    private static final String MAVEN_REPOSITORIES_FILE_NAME = ".idea/gcv-maven-repositories.xml";

    @Input
    public abstract SetProperty<String> getMavenRepositories();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    public GenerateMavenRepositoriesTask() {
        this.getOutputFile().set(this.getProject().file((Object)MAVEN_REPOSITORIES_FILE_NAME));
    }

    @TaskAction
    final void action() {
        this.writeRepositoriesToXml();
    }

    private void writeRepositoriesToXml() {
        File file = ((RegularFile)this.getOutputFile().get()).getAsFile();
        List<RepositoryConfig> repositories = ((Set)this.getMavenRepositories().get()).stream().map(ImmutableRepositoryConfig::of).collect(Collectors.toList());
        ImmutableRepositories wrapped = ImmutableRepositories.of(repositories);
        try {
            XML_MAPPER.writerWithDefaultPrettyPrinter().writeValue(file, (Object)wrapped);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonDeserialize(as=ImmutableRepositories.class)
    @JsonSerialize(as=ImmutableRepositories.class)
    @JsonRootName(value="repositories")
    @Value.Immutable
    static interface Repositories {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="repository")
        @Value.Parameter
        public List<RepositoryConfig> repositories();
    }

    @JsonDeserialize(as=ImmutableRepositoryConfig.class)
    @JsonSerialize(as=ImmutableRepositoryConfig.class)
    @Value.Immutable
    static interface RepositoryConfig {
        @JacksonXmlProperty(isAttribute=true)
        @Value.Parameter
        public String url();
    }
}

