/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Strings;
import com.palantir.gradle.failurereports.exceptions.ExceptionWithSuggestion;
import java.nio.file.Path;

public final class Validators {
    public static void checkResultOrThrow(boolean condition, String errorTemplate, String commandSuggestion) {
        if (!condition) {
            throw new ExceptionWithSuggestion(Strings.lenientFormat((String)errorTemplate, (Object[])new Object[]{commandSuggestion}), commandSuggestion);
        }
    }

    public static void checkResultOrThrow(boolean result, String errorMessage, Path filePath) {
        if (!result) {
            throw new ExceptionWithSuggestion(errorMessage, filePath.getFileName().toString());
        }
    }

    public static void checkResultOrThrow(boolean result, String errorMessage, Path filePath, int lineNumber) {
        if (!result) {
            throw new ExceptionWithSuggestion(errorMessage, Validators.getInvalidFileLine(filePath, lineNumber));
        }
    }

    private static String getInvalidFileLine(Path filePath, int lineNumber) {
        return String.format("%s:%d", filePath.getFileName().toString(), lineNumber);
    }

    private Validators() {
    }
}

