/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Sets;
import com.palantir.gradle.versions.DependencyConstraintCreator;
import com.palantir.gradle.versions.FuzzyPatternResolver;
import com.palantir.gradle.versions.Validators;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleIdentifier;

public final class VersionsProps {
    private static final Pattern CONSTRAINT = Pattern.compile("^([^# :]+:[^# ]+)\\s*=\\s*([^# ]+)#?.*$");
    private final FuzzyPatternResolver fuzzyResolver;
    private final Map<String, String> patternToPlatform;

    private VersionsProps(FuzzyPatternResolver fuzzyResolver) {
        this.fuzzyResolver = fuzzyResolver;
        this.patternToPlatform = Sets.difference(fuzzyResolver.versions().keySet(), fuzzyResolver.exactMatches()).stream().collect(Collectors.toMap(key -> key, this::constructPlatform));
    }

    public FuzzyPatternResolver getFuzzyResolver() {
        return this.fuzzyResolver;
    }

    public static VersionsProps loadFromFile(Path path) {
        List<String> lines = VersionsProps.safeReadLines(path);
        return VersionsProps.fromLines(lines, path);
    }

    public static VersionsProps fromLines(List<String> lines, Path path) {
        FuzzyPatternResolver.Builder builder = FuzzyPatternResolver.builder();
        HashMap<String, String> versions = new HashMap<String, String>();
        int lineNumber = 1;
        for (String line : lines) {
            Matcher constraint = CONSTRAINT.matcher(line);
            if (constraint.matches()) {
                String key = constraint.group(1);
                String value = constraint.group(2);
                Validators.checkResultOrThrow(CharMatcher.is((char)':').countIn((CharSequence)key) == 1, String.format("Encountered invalid artifact name '%s' in versions.props", key), path, lineNumber);
                Validators.checkResultOrThrow(!value.isEmpty(), String.format("Encountered missing version for artifact '%s' in versions.props", value), path, lineNumber);
                Validators.checkResultOrThrow(!versions.containsKey(key), String.format("Encountered duplicate constraint for '%s' in versions.props. Please remove one of the entries:\n    %s = %s\n    %s = %s\n", key, key, versions.get(key), key, value), path, lineNumber);
                versions.put(key, value);
            } else {
                Validators.checkResultOrThrow(line.trim().isEmpty() || line.startsWith("#"), "Encountered invalid constraint " + line, path, lineNumber);
            }
            ++lineNumber;
        }
        builder.putAllVersions(versions);
        return new VersionsProps(builder.build());
    }

    private static List<String> safeReadLines(Path file) {
        try {
            return Files.readAllLines(file);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading " + file);
        }
    }

    static VersionsProps empty() {
        return new VersionsProps(FuzzyPatternResolver.builder().build());
    }

    public Stream<DependencyConstraint> constructConstraints(DependencyConstraintCreator constraintCreator) {
        Map<String, String> versions = this.fuzzyResolver.versions();
        return Stream.concat(this.fuzzyResolver.exactMatches().stream().map(key -> key + ":" + (String)versions.get(key)).map(constraintCreator::create), this.patternToPlatform.entrySet().stream().map(entry -> (String)entry.getValue() + ":" + (String)versions.get(entry.getKey())).map(constraintCreator::create));
    }

    public Optional<String> getStarVersion(ModuleIdentifier dependency) {
        String notation = dependency.getGroup() + ":" + dependency.getName();
        return this.fuzzyResolver.patternFor(notation).map(this.fuzzyResolver.versions()::get);
    }

    public Optional<String> getPlatform(ModuleIdentifier dependency) {
        String notation = dependency.getGroup() + ":" + dependency.getName();
        if (this.fuzzyResolver.exactMatches().contains(notation)) {
            return Optional.empty();
        }
        return this.fuzzyResolver.patternFor(notation).map(this.patternToPlatform::get);
    }

    private String constructPlatform(String glob) {
        int occurrences = -1;
        String sub = glob;
        int lastIdx = 0;
        while (lastIdx != -1) {
            lastIdx = sub.indexOf(":");
            sub = sub.substring(lastIdx + 1);
            ++occurrences;
        }
        String sanitized = glob.replaceAll("\\*", "_");
        if (occurrences == 0) {
            return "org:" + sanitized;
        }
        if (occurrences >= 2) {
            throw new IllegalArgumentException("Encountered a glob constraint with more than one ':' in it: " + glob);
        }
        return sanitized;
    }
}

