/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.palantir.gradle.versions.CheckOverbroadConstraints;
import com.palantir.gradle.versions.CheckUnusedConstraintsTask;
import com.palantir.gradle.versions.DependencyConstraintCreator;
import com.palantir.gradle.versions.GradleWorkarounds;
import com.palantir.gradle.versions.VersionRecommendationsExtension;
import com.palantir.gradle.versions.VersionsProps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.dsl.DependencyConstraintHandler;
import org.gradle.api.attributes.Usage;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.util.GradleVersion;

public class VersionsPropsPlugin
implements Plugin<Project> {
    private static final Logger log = Logging.getLogger(VersionsPropsPlugin.class);
    private static final String ROOT_CONFIGURATION_NAME = "rootConfiguration";
    private static final GradleVersion MINIMUM_GRADLE_VERSION = GradleVersion.version((String)"5.2");
    private static final ImmutableSet<String> JAVA_PUBLISHED_CONFIGURATION_NAMES = ImmutableSet.of((Object)"runtimeElements", (Object)"apiElements");
    private static final String GCV_VERSIONS_PROPS_CONSTRAINTS_CONFIGURATION_NAME = "gcvVersionsPropsConstraints";
    private static final String VERSION_PROPS_EXTENSION = "versionsProps";

    public final void apply(Project project) {
        VersionsPropsPlugin.checkPreconditions();
        Usage gcvVersionsPropsUsage = (Usage)project.getObjects().named(Usage.class, "consistent-versions-usage");
        String gcvVersionsPropsCapability = "gcv:versions-props:0";
        VersionsProps versionsProps = VersionsPropsPlugin.getVersionsProps(project.getRootProject());
        if (project.getRootProject().equals(project)) {
            VersionsPropsPlugin.applyToRootProject(project);
            TaskProvider checkNoUnusedConstraints = project.getTasks().register("checkUnusedConstraints", CheckUnusedConstraintsTask.class, task -> {
                if (project.getGradle().getStartParameter().isConfigureOnDemand() && project.getAllprojects().stream().anyMatch(p -> !p.getState().getExecuted())) {
                    task.setShouldFailWithConfigurationOnDemandMessage(true);
                } else {
                    task.getClasspath().set(project.provider(() -> project.getAllprojects().stream().flatMap(proj -> CheckUnusedConstraintsTask.getResolvedModuleIdentifiers(proj, (VersionRecommendationsExtension)project.getExtensions().getByType(VersionRecommendationsExtension.class))).collect(Collectors.toSet())));
                }
                task.getPropsFile().set((Object)project.getLayout().getProjectDirectory().file("versions.props"));
            });
            project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{checkNoUnusedConstraints}));
            TaskProvider checkOverbroadConstraints = project.getTasks().register("checkOverbroadConstraints", CheckOverbroadConstraints.class, task -> {
                task.getLockFile().set((Object)project.getLayout().getProjectDirectory().file("versions.lock"));
                task.getPropsFile().set((Object)project.getLayout().getProjectDirectory().file("versions.props"));
            });
            project.getTasks().named("check").configure(task -> task.dependsOn(new Object[]{checkOverbroadConstraints}));
            project.getConfigurations().register(GCV_VERSIONS_PROPS_CONSTRAINTS_CONFIGURATION_NAME, conf -> {
                conf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)gcvVersionsPropsUsage);
                conf.getOutgoing().capability((Object)gcvVersionsPropsCapability);
                conf.setCanBeResolved(false);
                conf.setCanBeConsumed(true);
                conf.setVisible(false);
                VersionsPropsPlugin.addVersionsPropsConstraints((arg_0, arg_1) -> ((DependencyConstraintHandler)project.getDependencies().getConstraints()).create(arg_0, arg_1), conf, versionsProps);
            });
        }
        VersionRecommendationsExtension extension = (VersionRecommendationsExtension)project.getRootProject().getExtensions().getByType(VersionRecommendationsExtension.class);
        NamedDomainObjectProvider rootConfiguration = project.getConfigurations().register(ROOT_CONFIGURATION_NAME, conf -> {
            conf.setCanBeResolved(false);
            conf.setCanBeConsumed(false);
            conf.setVisible(false);
            conf.getDependencies().add((Object)VersionsPropsPlugin.createDepOnRootConstraintsConfiguration(project, gcvVersionsPropsUsage, gcvVersionsPropsCapability));
        });
        project.getConfigurations().configureEach(conf -> VersionsPropsPlugin.setupConfiguration(project, extension, (Configuration)rootConfiguration.get(), versionsProps, conf));
        log.debug("Configuring rules to assign *-constraints to platforms in {}", (Object)project);
        project.getDependencies().getComponents().all(component -> VersionsPropsPlugin.tryAssignComponentToPlatform(versionsProps, component));
        VersionsPropsPlugin.configureResolvedVersionsWithVersionMapping(project);
    }

    private static ProjectDependency createDepOnRootConstraintsConfiguration(Project project, Usage usage, String capability) {
        ProjectDependency projectDep = (ProjectDependency)project.getDependencies().create((Object)project.getRootProject());
        projectDep.capabilities(capabilities -> capabilities.requireCapability((Object)capability));
        projectDep.attributes(attrs -> attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)usage));
        return projectDep;
    }

    private static void applyToRootProject(Project project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        project.getExtensions().create("versionRecommendations", VersionRecommendationsExtension.class, new Object[]{project});
        project.subprojects(subproject -> subproject.getPluginManager().apply(VersionsPropsPlugin.class));
    }

    private static void setupConfiguration(Project subproject, VersionRecommendationsExtension extension, Configuration rootConfiguration, VersionsProps versionsProps, Configuration conf) {
        if (conf.getName().equals(ROOT_CONFIGURATION_NAME)) {
            conf.withDependencies(deps -> VersionsPropsPlugin.provideVersionsFromStarDependencies(versionsProps, deps));
            return;
        }
        if (conf.getName().equals(GCV_VERSIONS_PROPS_CONSTRAINTS_CONFIGURATION_NAME)) {
            return;
        }
        if (JAVA_PUBLISHED_CONFIGURATION_NAMES.contains((Object)conf.getName())) {
            log.debug("Only configuring BOM dependencies on published java configuration: {}", (Object)conf);
            conf.getDependencies().addAllLater(VersionsPropsPlugin.extractPlatformDependencies(subproject, rootConfiguration));
            return;
        }
        AtomicBoolean wasConfigured = new AtomicBoolean();
        conf.withDependencies(deps -> {
            if (!wasConfigured.compareAndSet(false, true)) {
                log.debug("Not configuring {} because it's a copy of an already configured configuration.", (Object)conf);
                return;
            }
            if (extension.shouldExcludeConfiguration(conf.getName())) {
                log.debug("Not configuring {} because it's excluded", (Object)conf);
                return;
            }
            VersionsPropsPlugin.provideVersionsFromStarDependencies(versionsProps, deps);
            if (VersionsPropsPlugin.configurationWillAffectPublishedConstraints(subproject, conf)) {
                log.debug("Not configuring published java configuration or its ancestor: {}", (Object)conf);
                return;
            }
            conf.extendsFrom(new Configuration[]{rootConfiguration});
            if ("unifiedClasspath".equals(conf.getName())) {
                return;
            }
            conf.getIncoming().beforeResolve(_resolvableDependencies -> {
                if (GradleWorkarounds.isConfiguring(subproject.getState())) {
                    throw new GradleException(String.format("Not allowed to resolve %s at configuration time (https://guides.gradle.org/performance/#don_t_resolve_dependencies_at_configuration_time). Please upgrade your plugins and double-check your gradle scripts (see stacktrace)", conf));
                }
            });
        });
    }

    private static boolean configurationWillAffectPublishedConstraints(Project subproject, Configuration conf) {
        return JAVA_PUBLISHED_CONFIGURATION_NAMES.stream().anyMatch(confName -> VersionsPropsPlugin.isSameOrSuperconfigurationOf(subproject, conf, confName));
    }

    private static boolean isSameOrSuperconfigurationOf(Project project, Configuration conf, String targetConfigurationName) {
        if (project.getConfigurations().findByName(targetConfigurationName) == null) {
            return false;
        }
        Configuration targetConf = project.getConfigurations().getByName(targetConfigurationName);
        return targetConf.getHierarchy().contains(conf);
    }

    private static Provider<List<Dependency>> extractPlatformDependencies(Project project, Configuration rootConfiguration) {
        ListProperty proxiedDependencies = project.getObjects().listProperty(Dependency.class);
        proxiedDependencies.addAll(project.provider(() -> rootConfiguration.getDependencies().withType(ModuleDependency.class).matching(dep -> GradleWorkarounds.isPlatform(dep.getAttributes()))));
        return GradleWorkarounds.fixListProperty(proxiedDependencies);
    }

    private static void provideVersionsFromStarDependencies(VersionsProps versionsProps, DependencySet deps) {
        deps.withType(ExternalDependency.class).configureEach(moduleDependency -> {
            if (moduleDependency.getVersion() != null) {
                return;
            }
            versionsProps.getStarVersion(moduleDependency.getModule()).ifPresent(version -> moduleDependency.version(constraint -> {
                log.debug("Found direct dependency without version: {} -> {}, requiring: {}", new Object[]{deps, moduleDependency, version});
                constraint.require(version);
            }));
        });
    }

    private static void tryAssignComponentToPlatform(VersionsProps versionsProps, ComponentMetadataDetails component) {
        log.debug("Configuring component: {}", (Object)component);
        versionsProps.getPlatform(component.getId().getModule()).ifPresent(platform -> {
            String platformNotation = platform + ":" + component.getId().getVersion();
            log.debug("Assigning component {} to virtual platform {}", (Object)component, (Object)platformNotation);
            component.belongsTo((Object)platformNotation);
        });
    }

    private static void addVersionsPropsConstraints(DependencyConstraintCreator constraintCreator, Configuration conf, VersionsProps versionsProps) {
        ImmutableList constraints = (ImmutableList)versionsProps.constructConstraints(constraintCreator).collect(ImmutableList.toImmutableList());
        log.debug("Adding constraints to {}: {}", (Object)conf, (Object)constraints);
        constraints.forEach(arg_0 -> conf.getDependencyConstraints().add(arg_0));
    }

    private static VersionsProps getVersionsProps(Project rootProject) {
        VersionsProps versionsProps = (VersionsProps)rootProject.getExtensions().findByType(VersionsProps.class);
        if (versionsProps == null) {
            versionsProps = VersionsPropsPlugin.loadVersionsProps(rootProject.file((Object)"versions.props").toPath());
            rootProject.getExtensions().add(VERSION_PROPS_EXTENSION, (Object)versionsProps);
        }
        return versionsProps;
    }

    private static VersionsProps loadVersionsProps(Path versionsPropsFile) {
        if (!Files.exists(versionsPropsFile, new LinkOption[0])) {
            return VersionsProps.empty();
        }
        log.debug("Configuring constraints from properties file {}", (Object)versionsPropsFile);
        return VersionsProps.loadFromFile(versionsPropsFile);
    }

    private static void checkPreconditions() {
        Preconditions.checkState((GradleVersion.current().compareTo(MINIMUM_GRADLE_VERSION) >= 0 ? 1 : 0) != 0, (String)"This plugin requires gradle >= %s", (Object)MINIMUM_GRADLE_VERSION);
    }

    private static void configureResolvedVersionsWithVersionMapping(Project project) {
        project.getPluginManager().withPlugin("maven-publish", _plugin -> ((PublishingExtension)project.getExtensions().getByType(PublishingExtension.class)).getPublications().withType(MavenPublication.class).configureEach(publication -> publication.versionMapping(mapping -> mapping.allVariants(VariantVersionMappingStrategy::fromResolutionResult))));
    }
}

