/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions;

import com.google.common.base.Splitter;
import com.palantir.gradle.failurereports.exceptions.ExceptionWithSuggestion;
import com.palantir.gradle.versions.ConflictSafeLockFile;
import com.palantir.gradle.versions.internal.MyModuleVersionIdentifier;
import com.palantir.gradle.versions.lockstate.Dependents;
import com.palantir.gradle.versions.lockstate.FullLockState;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockStates;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class WhyDependencyTask
extends DefaultTask {
    private final Property<String> hashOption = this.getProject().getObjects().property(String.class);
    private final Property<String> dependencyOption = this.getProject().getObjects().property(String.class);
    private final Property<FullLockState> fullLockState = this.getProject().getObjects().property(FullLockState.class);
    private Path lockfile;

    public WhyDependencyTask() {
        this.setGroup("Help");
        this.setDescription("Explains what a specific hash in versions.lock means");
    }

    @Option(option="hash", description="Hash from versions.lock to explain")
    public final void setHashOption(String string) {
        this.hashOption.set((Object)string);
    }

    @Option(option="dependency", description="Dependency from versions.lock to explain")
    public final void setDependencyOption(String string) {
        this.dependencyOption.set((Object)string);
    }

    public final void lockfile(Path path) {
        this.lockfile = path;
    }

    public final void fullLockState(Provider<FullLockState> provider) {
        this.fullLockState.set(provider);
    }

    @TaskAction
    public final void taskAction() {
        List<Line> lines = new ConflictSafeLockFile(this.lockfile).readLocks().allLines();
        if (!this.hashOption.isPresent() && !this.dependencyOption.isPresent()) {
            Optional<String> example = lines.stream().findFirst().map(line -> ", e.g. './gradlew why --dependency " + line.name() + "'");
            throw new ExceptionWithSuggestion("./gradlew why requires a '--dependency <dependency>' option" + example.orElse(""), example.orElse("./gradlew why --dependency <dependency>"));
        }
        Optional<Set> hashes = Optional.ofNullable((String)this.hashOption.getOrNull()).map(hash -> Set.copyOf(Splitter.on((String)",").splitToList((CharSequence)hash)));
        Optional<String> dependency = Optional.ofNullable((String)this.dependencyOption.getOrNull());
        for (Line line2 : lines) {
            if ((!hashes.isPresent() || !hashes.get().contains(line2.dependentsHash())) && (!dependency.isPresent() || !line2.identifier().toString().contains(dependency.get()))) continue;
            MyModuleVersionIdentifier key = MyModuleVersionIdentifier.of(line2.group(), line2.name(), line2.version());
            Optional<Dependents> entry = Stream.of(((FullLockState)this.fullLockState.get()).productionDeps(), ((FullLockState)this.fullLockState.get()).testDeps()).map(state -> (Dependents)state.get(key)).filter(Objects::nonNull).findFirst();
            Dependents dependents = entry.orElseThrow(() -> new NullPointerException("Unable to find group/name in fullLockState"));
            this.getLogger().lifecycle("{}", new Object[]{key});
            LockStates.prettyPrintConstraints(dependents).forEach(pretty -> this.getLogger().lifecycle("\t{}", new Object[]{pretty}));
            this.getLogger().lifecycle("");
        }
    }
}

