/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.versions.internal.MyModuleIdentifier;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MyModuleIdentifier", generator="Immutables")
@Immutable
final class ImmutableMyModuleIdentifier
extends MyModuleIdentifier {
    private final String group;
    private final String name;

    private ImmutableMyModuleIdentifier(String group, String name) {
        this.group = Objects.requireNonNull(group, "group");
        this.name = Objects.requireNonNull(name, "name");
    }

    private ImmutableMyModuleIdentifier(ImmutableMyModuleIdentifier original, String group, String name) {
        this.group = group;
        this.name = name;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public final ImmutableMyModuleIdentifier withGroup(String value) {
        String newValue = Objects.requireNonNull(value, "group");
        if (this.group.equals(newValue)) {
            return this;
        }
        return new ImmutableMyModuleIdentifier(this, newValue, this.name);
    }

    public final ImmutableMyModuleIdentifier withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableMyModuleIdentifier(this, this.group, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMyModuleIdentifier && this.equalTo((ImmutableMyModuleIdentifier)another);
    }

    private boolean equalTo(ImmutableMyModuleIdentifier another) {
        return this.group.equals(another.group) && this.name.equals(another.name);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.group.hashCode();
        h += (h << 5) + this.name.hashCode();
        return h;
    }

    public static MyModuleIdentifier of(String group, String name) {
        return new ImmutableMyModuleIdentifier(group, name);
    }

    public static MyModuleIdentifier copyOf(MyModuleIdentifier instance) {
        if (instance instanceof ImmutableMyModuleIdentifier) {
            return (ImmutableMyModuleIdentifier)instance;
        }
        return ImmutableMyModuleIdentifier.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MyModuleIdentifier", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GROUP = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String group;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModuleIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MyModuleIdentifier instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ModuleIdentifier instance;
            long bits = 0L;
            if (object instanceof ModuleIdentifier) {
                instance = (ModuleIdentifier)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.group(instance.getGroup());
                    bits |= 2L;
                }
            }
            if (object instanceof MyModuleIdentifier) {
                instance = (MyModuleIdentifier)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.group(instance.getGroup());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder group(String group) {
            this.group = Objects.requireNonNull(group, "group");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public MyModuleIdentifier build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMyModuleIdentifier(null, this.group, this.name);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("group");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build MyModuleIdentifier, some of required attributes are not set " + attributes;
        }
    }
}

