/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.lockstate;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.versions.lockstate.Dependents;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Dependents", generator="Immutables")
@Immutable
public final class ImmutableDependents
implements Dependents {
    private final NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get;
    private final transient NavigableSet<VersionConstraint> projectConstraints;
    private final transient Map<ComponentIdentifier, Set<VersionConstraint>> nonProjectConstraints;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDependents(NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get) {
        this.get = Objects.requireNonNull(get, "get");
        this.projectConstraints = this.initShim.projectConstraints();
        this.nonProjectConstraints = this.initShim.nonProjectConstraints();
        this.initShim = null;
    }

    private ImmutableDependents(ImmutableDependents original, NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get) {
        this.get = get;
        this.projectConstraints = this.initShim.projectConstraints();
        this.nonProjectConstraints = this.initShim.nonProjectConstraints();
        this.initShim = null;
    }

    private NavigableSet<VersionConstraint> projectConstraintsInitialize() {
        return Dependents.super.projectConstraints();
    }

    private Map<ComponentIdentifier, Set<VersionConstraint>> nonProjectConstraintsInitialize() {
        return Dependents.super.nonProjectConstraints();
    }

    @Override
    public NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get() {
        return this.get;
    }

    @Override
    public NavigableSet<VersionConstraint> projectConstraints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.projectConstraints() : this.projectConstraints;
    }

    @Override
    public Map<ComponentIdentifier, Set<VersionConstraint>> nonProjectConstraints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nonProjectConstraints() : this.nonProjectConstraints;
    }

    public final ImmutableDependents withGet(NavigableMap<ComponentIdentifier, Set<VersionConstraint>> value) {
        if (this.get == value) {
            return this;
        }
        NavigableMap<ComponentIdentifier, Set<VersionConstraint>> newValue = Objects.requireNonNull(value, "get");
        return new ImmutableDependents(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDependents && this.equalTo((ImmutableDependents)another);
    }

    private boolean equalTo(ImmutableDependents another) {
        return this.get.equals(another.get) && this.projectConstraints.equals(another.projectConstraints) && this.nonProjectConstraints.equals(another.nonProjectConstraints);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.get.hashCode();
        h += (h << 5) + this.projectConstraints.hashCode();
        h += (h << 5) + this.nonProjectConstraints.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Dependents").omitNullValues().add("get", this.get).add("projectConstraints", this.projectConstraints).add("nonProjectConstraints", this.nonProjectConstraints).toString();
    }

    public static ImmutableDependents of(NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get) {
        return new ImmutableDependents(get);
    }

    public static ImmutableDependents copyOf(Dependents instance) {
        if (instance instanceof ImmutableDependents) {
            return (ImmutableDependents)instance;
        }
        return ImmutableDependents.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Dependents", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GET = 1L;
        private long initBits = 1L;
        @Nullable
        private NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Dependents instance) {
            Objects.requireNonNull(instance, "instance");
            this.get(instance.get());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder get(NavigableMap<ComponentIdentifier, Set<VersionConstraint>> get) {
            this.get = Objects.requireNonNull(get, "get");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDependents build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDependents(null, this.get);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("get");
            }
            return "Cannot build Dependents, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="Dependents", generator="Immutables")
    private final class InitShim {
        private byte projectConstraintsBuildStage = 0;
        private NavigableSet<VersionConstraint> projectConstraints;
        private byte nonProjectConstraintsBuildStage = 0;
        private Map<ComponentIdentifier, Set<VersionConstraint>> nonProjectConstraints;

        private InitShim() {
        }

        NavigableSet<VersionConstraint> projectConstraints() {
            if (this.projectConstraintsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.projectConstraintsBuildStage == 0) {
                this.projectConstraintsBuildStage = (byte)-1;
                this.projectConstraints = Objects.requireNonNull(ImmutableDependents.this.projectConstraintsInitialize(), "projectConstraints");
                this.projectConstraintsBuildStage = 1;
            }
            return this.projectConstraints;
        }

        Map<ComponentIdentifier, Set<VersionConstraint>> nonProjectConstraints() {
            if (this.nonProjectConstraintsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nonProjectConstraintsBuildStage == 0) {
                this.nonProjectConstraintsBuildStage = (byte)-1;
                this.nonProjectConstraints = Objects.requireNonNull(ImmutableDependents.this.nonProjectConstraintsInitialize(), "nonProjectConstraints");
                this.nonProjectConstraintsBuildStage = 1;
            }
            return this.nonProjectConstraints;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.projectConstraintsBuildStage == -1) {
                attributes.add("projectConstraints");
            }
            if (this.nonProjectConstraintsBuildStage == -1) {
                attributes.add("nonProjectConstraints");
            }
            return "Cannot build Dependents, attribute initializers form cycle " + attributes;
        }
    }
}

