/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.versions.lockstate;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.gradle.versions.internal.MyModuleIdentifier;
import com.palantir.gradle.versions.lockstate.Line;
import com.palantir.gradle.versions.lockstate.LockState;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LockState", generator="Immutables")
@Immutable
public final class ImmutableLockState
implements LockState {
    private final ImmutableList<Line> productionLines;
    private final ImmutableList<Line> testLines;
    private volatile transient long lazyInitBitmap;
    private static final long ALL_LINES_LAZY_INIT_BIT = 1L;
    private transient List<Line> allLines;
    private static final long PRODUCTION_LINES_BY_MODULE_IDENTIFIER_LAZY_INIT_BIT = 2L;
    private transient NavigableMap<MyModuleIdentifier, Line> productionLinesByModuleIdentifier;
    private static final long TEST_LINES_BY_MODULE_IDENTIFIER_LAZY_INIT_BIT = 4L;
    private transient NavigableMap<MyModuleIdentifier, Line> testLinesByModuleIdentifier;

    private ImmutableLockState(Iterable<? extends Line> productionLines, Iterable<? extends Line> testLines) {
        this.productionLines = ImmutableList.copyOf(productionLines);
        this.testLines = ImmutableList.copyOf(testLines);
    }

    private ImmutableLockState(ImmutableLockState original, ImmutableList<Line> productionLines, ImmutableList<Line> testLines) {
        this.productionLines = productionLines;
        this.testLines = testLines;
    }

    public ImmutableList<Line> productionLines() {
        return this.productionLines;
    }

    public ImmutableList<Line> testLines() {
        return this.testLines;
    }

    public final ImmutableLockState withProductionLines(Line ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLockState(this, (ImmutableList<Line>)newValue, this.testLines);
    }

    public final ImmutableLockState withProductionLines(Iterable<? extends Line> elements) {
        if (this.productionLines == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLockState(this, (ImmutableList<Line>)newValue, this.testLines);
    }

    public final ImmutableLockState withTestLines(Line ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableLockState(this, this.productionLines, (ImmutableList<Line>)newValue);
    }

    public final ImmutableLockState withTestLines(Iterable<? extends Line> elements) {
        if (this.testLines == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableLockState(this, this.productionLines, (ImmutableList<Line>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLockState && this.equalTo((ImmutableLockState)another);
    }

    private boolean equalTo(ImmutableLockState another) {
        return this.productionLines.equals(another.productionLines) && this.testLines.equals(another.testLines);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.productionLines.hashCode();
        h += (h << 5) + this.testLines.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LockState").omitNullValues().add("productionLines", this.productionLines).add("testLines", this.testLines).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Line> allLines() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableLockState immutableLockState = this;
            synchronized (immutableLockState) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.allLines = Objects.requireNonNull(LockState.super.allLines(), "allLines");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.allLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<MyModuleIdentifier, Line> productionLinesByModuleIdentifier() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableLockState immutableLockState = this;
            synchronized (immutableLockState) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.productionLinesByModuleIdentifier = Objects.requireNonNull(LockState.super.productionLinesByModuleIdentifier(), "productionLinesByModuleIdentifier");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.productionLinesByModuleIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableMap<MyModuleIdentifier, Line> testLinesByModuleIdentifier() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableLockState immutableLockState = this;
            synchronized (immutableLockState) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.testLinesByModuleIdentifier = Objects.requireNonNull(LockState.super.testLinesByModuleIdentifier(), "testLinesByModuleIdentifier");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.testLinesByModuleIdentifier;
    }

    public static ImmutableLockState of(List<Line> productionLines, List<Line> testLines) {
        return ImmutableLockState.of(productionLines, testLines);
    }

    public static ImmutableLockState of(Iterable<? extends Line> productionLines, Iterable<? extends Line> testLines) {
        return new ImmutableLockState(productionLines, testLines);
    }

    public static ImmutableLockState copyOf(LockState instance) {
        if (instance instanceof ImmutableLockState) {
            return (ImmutableLockState)instance;
        }
        return ImmutableLockState.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LockState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Line> productionLines = ImmutableList.builder();
        private ImmutableList.Builder<Line> testLines = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LockState instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllProductionLines(instance.productionLines());
            this.addAllTestLines(instance.testLines());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProductionLines(Line element) {
            this.productionLines.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProductionLines(Line ... elements) {
            this.productionLines.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder productionLines(Iterable<? extends Line> elements) {
            this.productionLines = ImmutableList.builder();
            return this.addAllProductionLines(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProductionLines(Iterable<? extends Line> elements) {
            this.productionLines.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTestLines(Line element) {
            this.testLines.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTestLines(Line ... elements) {
            this.testLines.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder testLines(Iterable<? extends Line> elements) {
            this.testLines = ImmutableList.builder();
            return this.addAllTestLines(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTestLines(Iterable<? extends Line> elements) {
            this.testLines.addAll(elements);
            return this;
        }

        public ImmutableLockState build() {
            return new ImmutableLockState(null, (ImmutableList<Line>)this.productionLines.build(), (ImmutableList<Line>)this.testLines.build());
        }
    }
}

