/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.docker;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

final class GradleExecUtils {
    public static void execWithErrorMessage(Project project, Action<ExecSpec> execSpecAction) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList commandLine = new ArrayList();
        ExecResult execResult = project.exec(execSpec -> {
            execSpecAction.execute(execSpec);
            execSpec.setIgnoreExitValue(true);
            execSpec.setStandardOutput((OutputStream)output);
            execSpec.setErrorOutput((OutputStream)output);
            commandLine.addAll(execSpec.getCommandLine());
        });
        if (execResult.getExitValue() != 0) {
            throw new GradleException(String.format("The command '%s' failed with exit code %d. Output:\n%s", commandLine, execResult.getExitValue(), new String(output.toByteArray(), StandardCharsets.UTF_8)));
        }
    }

    private GradleExecUtils() {
    }
}

