/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.google.common.base.Preconditions;
import com.palantir.gradle.gitversion.GitVersionArgs;
import com.palantir.gradle.gitversion.JGitDescribe;
import com.palantir.gradle.gitversion.NativeGitDescribe;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionDetails {
    private static final Logger log = LoggerFactory.getLogger(VersionDetails.class);
    private static final int VERSION_ABBR_LENGTH = 10;
    private final Git git;
    private final GitVersionArgs args;
    private volatile String maybeCachedDescription = null;

    VersionDetails(Git git, GitVersionArgs args) {
        this.git = git;
        this.args = args;
    }

    public String getVersion() {
        if (this.description() == null) {
            return "unspecified";
        }
        return this.description() + (this.isClean() ? "" : ".dirty");
    }

    private boolean isClean() {
        try {
            return this.git.status().call().isClean();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private String description() {
        if (this.maybeCachedDescription != null) {
            return this.maybeCachedDescription;
        }
        String rawDescription = this.expensiveComputeRawDescription();
        this.maybeCachedDescription = rawDescription == null ? null : rawDescription.replaceFirst("^" + this.args.getPrefix(), "");
        return this.maybeCachedDescription;
    }

    private String expensiveComputeRawDescription() {
        if (this.isRepoEmpty()) {
            log.debug("Repository is empty");
            return null;
        }
        String nativeGitDescribe = new NativeGitDescribe(this.git.getRepository().getDirectory()).describe(this.args.getPrefix());
        String jgitDescribe = new JGitDescribe(this.git).describe(this.args.getPrefix());
        if (nativeGitDescribe == null) {
            return jgitDescribe;
        }
        Preconditions.checkState((boolean)nativeGitDescribe.equals(jgitDescribe), (String)"Inconsistent git describe: native was %s and jgit was %s. Please report this on github.com/palantir/gradle-git-version", (Object)nativeGitDescribe, (Object)jgitDescribe);
        return jgitDescribe;
    }

    private boolean isRepoEmpty() {
        try {
            this.git.describe().call();
            return false;
        }
        catch (Exception ignored) {
            return true;
        }
    }

    public boolean getIsCleanTag() {
        return this.isClean() && this.descriptionIsPlainTag();
    }

    private boolean descriptionIsPlainTag() {
        return !Pattern.matches(".*g.?[0-9a-fA-F]{3,}", this.description());
    }

    public int getCommitDistance() {
        if (this.descriptionIsPlainTag()) {
            return 0;
        }
        Matcher match = Pattern.compile("(.*)-([0-9]+)-g.?[0-9a-fA-F]{3,}").matcher(this.description());
        Preconditions.checkState((boolean)match.matches(), (String)"Cannot get commit distance for description: '%s'", (Object)this.description());
        return Integer.parseInt(match.group(2));
    }

    public String getLastTag() {
        if (this.descriptionIsPlainTag()) {
            return this.description();
        }
        Matcher match = Pattern.compile("(.*)-([0-9]+)-g.?[0-9a-fA-F]{3,}").matcher(this.description());
        return match.matches() ? match.group(1) : null;
    }

    public String getGitHash() throws IOException {
        String gitHashFull = this.getGitHashFull();
        if (gitHashFull == null) {
            return null;
        }
        return gitHashFull.substring(0, 10);
    }

    public String getGitHashFull() throws IOException {
        ObjectId objectId = this.git.getRepository().findRef("HEAD").getObjectId();
        if (objectId == null) {
            return null;
        }
        return objectId.name();
    }

    public String getBranchName() throws IOException {
        Ref ref = this.git.getRepository().findRef(this.git.getRepository().getBranch());
        if (ref == null) {
            return null;
        }
        return ref.getName().substring("refs/heads/".length());
    }

    public String toString() {
        try {
            return String.format("VersionDetails(%s, %s, %s, %s, %s)", this.getVersion(), this.getGitHash(), this.getGitHashFull(), this.getBranchName(), this.getIsCleanTag());
        }
        catch (IOException e) {
            return "";
        }
    }
}

