/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.gitversion;

import com.palantir.gradle.gitversion.GitVersionArgs;
import com.palantir.gradle.gitversion.Timer;
import com.palantir.gradle.gitversion.TimingVersionDetails;
import com.palantir.gradle.gitversion.VersionDetails;
import com.palantir.gradle.gitversion.VersionDetailsImpl;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GitVersionCacheService
implements BuildService<BuildServiceParameters.None> {
    private static final Logger log = LoggerFactory.getLogger(GitVersionCacheService.class);
    private final Timer timer = new Timer();
    private final ConcurrentMap<String, VersionDetails> versionDetailsMap = new ConcurrentHashMap<String, VersionDetails>();

    public final String getGitVersion(File project, Object args) {
        File gitDir = GitVersionCacheService.getRootGitDir(project);
        GitVersionArgs gitVersionArgs = GitVersionArgs.fromGroovyClosure(args);
        String key = gitDir.toPath() + "|" + gitVersionArgs.getPrefix();
        String gitVersion = this.versionDetailsMap.computeIfAbsent(key, _k -> this.createVersionDetails(gitDir, gitVersionArgs)).getVersion();
        return gitVersion;
    }

    public final VersionDetails getVersionDetails(File project, Object args) {
        File gitDir = GitVersionCacheService.getRootGitDir(project);
        GitVersionArgs gitVersionArgs = GitVersionArgs.fromGroovyClosure(args);
        String key = gitDir.toPath() + "|" + gitVersionArgs.getPrefix();
        VersionDetails versionDetails = this.versionDetailsMap.computeIfAbsent(key, _k -> this.createVersionDetails(gitDir, gitVersionArgs));
        return versionDetails;
    }

    private VersionDetails createVersionDetails(File gitDir, GitVersionArgs args) {
        try {
            return TimingVersionDetails.wrap(this.timer, new VersionDetailsImpl(gitDir, args));
        }
        catch (IOException e) {
            log.debug("Cannot compute version details", (Throwable)e);
            return null;
        }
    }

    public final Timer timer() {
        return this.timer;
    }

    private static File getRootGitDir(File currentRoot) {
        File gitDir = GitVersionCacheService.scanForRootGitDir(currentRoot);
        if (!gitDir.exists()) {
            throw new IllegalArgumentException("Cannot find '.git' directory");
        }
        return gitDir;
    }

    private static File scanForRootGitDir(File currentRoot) {
        File gitDir = new File(currentRoot, ".git");
        if (gitDir.exists()) {
            return gitDir;
        }
        if (currentRoot.getParentFile() == null) {
            return gitDir;
        }
        return GitVersionCacheService.scanForRootGitDir(currentRoot.getParentFile());
    }

    public static Provider<GitVersionCacheService> getSharedGitVersionCacheService(Project project) {
        return project.getGradle().getSharedServices().registerIfAbsent("GitVersionCacheService", GitVersionCacheService.class, _spec -> {});
    }
}

