/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.jdks.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.gradle.jdks.JdkDistributionName;
import com.palantir.gradle.jdks.json.JdkInfoJson;
import com.palantir.gradle.jdks.json.JdkOsInfoJson;
import com.palantir.gradle.jdks.setup.common.Os;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="JdkInfoJson", generator="Immutables")
final class ImmutableJdkInfoJson
extends JdkInfoJson
implements Serializable {
    private final JdkDistributionName distribution;
    private final Map<Os, JdkOsInfoJson> os;

    private ImmutableJdkInfoJson(JdkDistributionName distribution, Map<Os, JdkOsInfoJson> os) {
        this.distribution = distribution;
        this.os = os;
    }

    @Override
    @JsonProperty(value="distribution")
    public JdkDistributionName distribution() {
        return this.distribution;
    }

    @Override
    @JsonProperty(value="os")
    public Map<Os, JdkOsInfoJson> os() {
        return this.os;
    }

    public final ImmutableJdkInfoJson withDistribution(JdkDistributionName value) {
        JdkDistributionName newValue = Objects.requireNonNull(value, "distribution");
        if (this.distribution == newValue) {
            return this;
        }
        return new ImmutableJdkInfoJson(newValue, this.os);
    }

    public final ImmutableJdkInfoJson withOs(Map<Os, ? extends JdkOsInfoJson> entries) {
        if (this.os == entries) {
            return this;
        }
        Map<Os, JdkOsInfoJson> newValue = ImmutableJdkInfoJson.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutableJdkInfoJson(this.distribution, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJdkInfoJson && this.equalTo(0, (ImmutableJdkInfoJson)another);
    }

    private boolean equalTo(int synthetic, ImmutableJdkInfoJson another) {
        return this.distribution.equals((Object)another.distribution) && this.os.equals(another.os);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.distribution.hashCode();
        h += (h << 5) + this.os.hashCode();
        return h;
    }

    public String toString() {
        return "JdkInfoJson{distribution=" + this.distribution + ", os=" + this.os + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJdkInfoJson fromJson(Json json) {
        JdkInfoJson.Builder builder = new JdkInfoJson.Builder();
        if (json.distribution != null) {
            builder.distribution(json.distribution);
        }
        if (json.os != null) {
            builder.putAllOs(json.os);
        }
        return (ImmutableJdkInfoJson)builder.build();
    }

    public static JdkInfoJson copyOf(JdkInfoJson instance) {
        if (instance instanceof ImmutableJdkInfoJson) {
            return (ImmutableJdkInfoJson)instance;
        }
        return new JdkInfoJson.Builder().from(instance).build();
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    @Generated(from="JdkInfoJson", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_DISTRIBUTION = 1L;
        private long initBits = 1L;
        private JdkDistributionName distribution;
        private EnumMap<Os, JdkOsInfoJson> os = new EnumMap(Os.class);

        public Builder() {
            if (!(this instanceof JdkInfoJson.Builder)) {
                throw new UnsupportedOperationException("Use: new JdkInfoJson.Builder()");
            }
        }

        public final JdkInfoJson.Builder from(JdkInfoJson instance) {
            Objects.requireNonNull(instance, "instance");
            this.distribution(instance.distribution());
            this.putAllOs(instance.os());
            return (JdkInfoJson.Builder)this;
        }

        @JsonProperty(value="distribution")
        public final JdkInfoJson.Builder distribution(JdkDistributionName distribution) {
            this.distribution = Objects.requireNonNull(distribution, "distribution");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (JdkInfoJson.Builder)this;
        }

        public final JdkInfoJson.Builder putOs(Os key, JdkOsInfoJson value) {
            this.os.put(Objects.requireNonNull(key, "os key"), Objects.requireNonNull(value, value == null ? "os value for key: " + key : null));
            return (JdkInfoJson.Builder)this;
        }

        public final JdkInfoJson.Builder putOs(Map.Entry<Os, ? extends JdkOsInfoJson> entry) {
            JdkOsInfoJson v;
            Os k = entry.getKey();
            this.os.put(Objects.requireNonNull(k, "os key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "os value for key: " + k : null));
            return (JdkInfoJson.Builder)this;
        }

        @JsonProperty(value="os")
        public final JdkInfoJson.Builder os(Map<Os, ? extends JdkOsInfoJson> entries) {
            this.os.clear();
            return this.putAllOs(entries);
        }

        public final JdkInfoJson.Builder putAllOs(Map<Os, ? extends JdkOsInfoJson> entries) {
            for (Map.Entry<Os, ? extends JdkOsInfoJson> e : entries.entrySet()) {
                JdkOsInfoJson v;
                Os k = e.getKey();
                this.os.put(Objects.requireNonNull(k, "os key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "os value for key: " + k : null));
            }
            return (JdkInfoJson.Builder)this;
        }

        public JdkInfoJson build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJdkInfoJson(this.distribution, ImmutableJdkInfoJson.createUnmodifiableEnumMap(false, false, this.os));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("distribution");
            }
            return "Cannot build JdkInfoJson, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="JdkInfoJson", generator="Immutables")
    private static class SerialForm
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final String[] names;
        private final Object[] values;

        SerialForm(ImmutableJdkInfoJson instance) {
            ArrayList<String> names = new ArrayList<String>(2);
            ArrayList<Object> values = new ArrayList<Object>(2);
            names.add("distribution");
            values.add(instance.distribution());
            if (!instance.os().isEmpty()) {
                names.add("os");
                values.add(SerialForm.toArray(instance.os().entrySet()));
            }
            this.names = names.toArray(new String[names.size()]);
            this.values = values.toArray();
        }

        Object readResolve() {
            JdkInfoJson.Builder builder = new JdkInfoJson.Builder();
            for (int i = 0; i < this.names.length; ++i) {
                Object[] entries;
                String name = this.names[i];
                if ("distribution".equals(name)) {
                    builder.distribution((JdkDistributionName)SerialForm.toSingle("distribution", this.values[i]));
                    continue;
                }
                if (!"os".equals(name) || (entries = (Object[])this.values[i]) == null) continue;
                for (int j = 0; j < entries.length; j += 2) {
                    builder.putOs((Os)entries[j], (JdkOsInfoJson)entries[j + 1]);
                }
            }
            return builder.build();
        }

        private static Object toSingle(String attribute, Object value) {
            if (value instanceof Object[]) {
                Object[] elements = (Object[])value;
                if (elements.length == 1) {
                    return elements[0];
                }
                throw new IllegalStateException("Cannot extract scalar value for attribute '" + attribute + "' from array of length " + elements.length);
            }
            return value;
        }

        private static Object[] toArray(Collection<? extends Map.Entry<?, ?>> entries) {
            Object[] data = new Object[entries.size() * 2];
            int p = 0;
            for (Map.Entry<?, ?> e : entries) {
                data[p++] = e.getKey();
                data[p++] = e.getValue();
            }
            return data;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JdkInfoJson", generator="Immutables")
    static final class Json
    extends JdkInfoJson
    implements Serializable {
        JdkDistributionName distribution;
        Map<Os, JdkOsInfoJson> os = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="distribution")
        public void setDistribution(JdkDistributionName distribution) {
            this.distribution = distribution;
        }

        @JsonProperty(value="os")
        public void setOs(Map<Os, JdkOsInfoJson> os) {
            this.os = os;
        }

        @Override
        public JdkDistributionName distribution() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<Os, JdkOsInfoJson> os() {
            throw new UnsupportedOperationException();
        }
    }
}

