/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.jdks.setup;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;

public final class FileUtils {
    public static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            FileUtils.deleteDirectory(path);
        } else {
            FileUtils.deleteFile(path);
        }
    }

    private static void deleteDirectory(Path dir) {
        try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(FileUtils::deleteFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete directory", e);
        }
    }

    private static void deleteFile(Path targetPath) {
        try {
            Files.delete(targetPath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to delete path %s", targetPath), e);
        }
    }

    public static void copyDirectory(final Path source, final Path destination) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes _attrs) throws IOException {
                Files.createDirectories(destination.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes _attrs) throws IOException {
                Files.copy(file, destination.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path _file, IOException exc) throws IOException {
                throw new IOException("Failed to copy file", exc);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path _dir, IOException exc) throws IOException {
                if (Optional.ofNullable(exc).isPresent()) {
                    throw new RuntimeException("Failed to copy directory", exc);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void createDirectories(Path directoryPath) {
        try {
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not create directory %s", directoryPath), e);
        }
    }

    private FileUtils() {
    }
}

