/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.jdks.setup;

import com.palantir.gradle.jdks.setup.CaResources;
import com.palantir.gradle.jdks.setup.FileUtils;
import com.palantir.gradle.jdks.setup.ILogger;
import com.palantir.gradle.jdks.setup.StdErrLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public final class GradleJdkInstallationSetup {
    public static void main(String[] args) {
        StdErrLogger logger = new StdErrLogger();
        CaResources caResources = new CaResources(logger);
        if (args.length < 1) {
            throw new IllegalArgumentException("Expected at least an argument: jdkSetup or daemonSetup");
        }
        Command command = Command.fromLabel(args[0]);
        switch (command) {
            case JDK_SETUP: {
                GradleJdkInstallationSetup.setupJdk(logger, caResources, args);
                break;
            }
            case DAEMON_SETUP: {
                GradleJdkInstallationSetup.setupDaemon(args);
            }
        }
    }

    private static void setupDaemon(String[] args) {
        if (args.length != 3) {
            throw new IllegalArgumentException("Expected 2 arguments: daemonSetup <projectDir> <gradleDaemonJavaHome>");
        }
        Path projectDir = Path.of(args[1], new String[0]);
        Path gradleDaemonJavaHome = Path.of(args[2], new String[0]);
        try {
            Files.createDirectories(projectDir.resolve(".gradle"), new FileAttribute[0]);
            Path gradleConfigFile = projectDir.resolve(".gradle/config.properties");
            gradleConfigFile.toFile().createNewFile();
            Properties gradleProperties = new Properties();
            gradleProperties.load(new FileInputStream(gradleConfigFile.toFile()));
            gradleProperties.setProperty("java.home", gradleDaemonJavaHome.toString());
            gradleProperties.store(Files.newBufferedWriter(gradleConfigFile, StandardCharsets.UTF_8, new OpenOption[0]), null);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to set the java.home value in .gradle/config.properties.", e);
        }
    }

    private static void setupJdk(StdErrLogger logger, CaResources caResources, String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException("Expected 2 arguments: jdkSetup <destinationJdkInstallationDir>");
        }
        Path destinationJdkInstallationDir = Path.of(args[1], new String[0]);
        boolean wasCopied = GradleJdkInstallationSetup.copy(logger, destinationJdkInstallationDir);
        if (wasCopied) {
            caResources.importAllSystemCerts(destinationJdkInstallationDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copy(ILogger logger, Path destinationJdkInstallationDirectory) {
        Path currentJavaHome = Path.of(System.getProperty("java.home"), new String[0]);
        Path jdksInstallationDirectory = destinationJdkInstallationDirectory.getParent();
        FileUtils.createDirectories(jdksInstallationDirectory);
        Path lockFile = jdksInstallationDirectory.resolve(destinationJdkInstallationDirectory.getFileName() + ".lock");
        try (FileChannel channel = FileChannel.open(lockFile, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            channel.lock();
            if (Files.exists(destinationJdkInstallationDirectory, new LinkOption[0]) && Files.exists(destinationJdkInstallationDirectory.resolve("bin/java"), new LinkOption[0])) {
                logger.log(String.format("Distribution URL %s already exists", destinationJdkInstallationDirectory));
                boolean bl2 = false;
                return bl2;
            }
            logger.log(String.format("Copying JDK from %s into %s", currentJavaHome, destinationJdkInstallationDirectory));
            Path tempCopyDir = jdksInstallationDirectory.resolve(String.format("tmp-%s", destinationJdkInstallationDirectory.getFileName()));
            try {
                Files.createDirectories(tempCopyDir, new FileAttribute[0]);
                FileUtils.copyDirectory(currentJavaHome, tempCopyDir);
                Files.move(tempCopyDir, destinationJdkInstallationDirectory, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException ignored) {
                Files.move(tempCopyDir, destinationJdkInstallationDirectory, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                FileUtils.delete(tempCopyDir);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to copy the JDK installation to path= %s", destinationJdkInstallationDirectory), e);
        }
    }

    private GradleJdkInstallationSetup() {
    }

    public static enum Command {
        JDK_SETUP("jdkSetup"),
        DAEMON_SETUP("daemonSetup");

        private final String label;

        private Command(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }

        public static Command fromLabel(String label) {
            for (Command e : Command.values()) {
                if (!e.label.equals(label)) continue;
                return e;
            }
            throw new RuntimeException(String.format("Cannot convert %s to a Command", label));
        }
    }
}

