/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.plugintesting;

import com.palantir.baseline.tasks.CheckUnusedDependenciesParentTask;
import com.palantir.gradle.plugintesting.PluginTestingExtension;
import com.palantir.gradle.plugintesting.TestDependencyVersionsTask;
import java.util.Optional;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class PluginTestingPlugin
implements Plugin<Project> {
    static final String PLUGIN_VERSION_PROPERTY_NAME = "pluginTestingPluginVersion";
    private static final String MAVEN_GROUP = "com.palantir.gradle.plugintesting";
    private static final String CORE_MAVEN_NAME = "plugin-testing-core";
    private static final String CORE_MAVEN_COORDINATES = "com.palantir.gradle.plugintesting:plugin-testing-core";

    public void apply(Project project) {
        project.getExtensions().create("gradleTestUtils", PluginTestingExtension.class, new Object[0]);
        project.getPluginManager().withPlugin("java", _unused -> PluginTestingPlugin.doApply(project));
    }

    private static void doApply(Project project) {
        final PluginTestingExtension testUtilsExt = (PluginTestingExtension)project.getExtensions().getByType(PluginTestingExtension.class);
        PluginTestingPlugin.addTestDependency(project);
        final TaskProvider testDependencyVersions = project.getTasks().register("writeTestDependencyVersions", TestDependencyVersionsTask.class, task -> {
            SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet sourceSet = (SourceSet)sourceSetContainer.getByName("test");
            NamedDomainObjectProvider testRuntimeConfig = project.getConfigurations().named(sourceSet.getRuntimeClasspathConfigurationName());
            task.getClasspathConfiguration().set((Provider)testRuntimeConfig);
        });
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.dependsOn(new Object[]{testDependencyVersions});
            Action<Task> action = new Action<Task>(){

                public void execute(Task _task) {
                    test.systemProperty("TEST_DEPENDENCIES_FILE", (Object)((RegularFile)((TestDependencyVersionsTask)((Object)testDependencyVersions.get())).getOutputFile().get()).getAsFile().getAbsolutePath());
                    String versions = String.join((CharSequence)",", (Iterable)testUtilsExt.getGradleVersions().get());
                    test.systemProperty("TEST_GRADLE_VERSIONS", (Object)versions);
                    if (((Boolean)testUtilsExt.getIgnoreGradleDeprecations().get()).booleanValue()) {
                        test.systemProperty("ignoreDeprecations", (Object)"true");
                    }
                }
            };
            test.doFirst((Action)action);
        });
    }

    private static void addTestDependency(Project project) {
        SourceSetContainer sourceSetContainer = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        SourceSet testSourceSet = (SourceSet)sourceSetContainer.getByName("test");
        String version = Optional.ofNullable((String)project.findProperty(PLUGIN_VERSION_PROPERTY_NAME)).or(() -> Optional.ofNullable(PluginTestingPlugin.class.getPackage().getImplementationVersion())).orElseThrow(() -> new RuntimeException("PluginTestingPlugin implementation version not found"));
        String testImplConfigName = testSourceSet.getImplementationConfigurationName();
        project.getConfigurations().named(testImplConfigName).configure(conf -> conf.getDependencies().add((Object)project.getDependencies().create((Object)("com.palantir.gradle.plugintesting:plugin-testing-core:" + version))));
        project.getPluginManager().withPlugin("com.palantir.baseline-exact-dependencies", _unused -> project.getTasks().withType(CheckUnusedDependenciesParentTask.class).configureEach(task -> task.ignore(MAVEN_GROUP, CORE_MAVEN_NAME)));
    }
}

