/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.plugintesting;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public abstract class TestDependencyVersionsTask
extends DefaultTask {
    public TestDependencyVersionsTask() {
        this.getOutputFile().convention(this.getProject().getLayout().getBuildDirectory().file("plugin-testing/dependency-versions.properties"));
    }

    @Classpath
    abstract Property<Configuration> getClasspathConfiguration();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @TaskAction
    public final void doAction() {
        List<String> depSet = TestDependencyVersionsTask.getDependencyStrings((Configuration)this.getClasspathConfiguration().get());
        String depsString = String.join((CharSequence)"\n", depSet);
        try {
            Files.write(((RegularFile)this.getOutputFile().get()).getAsFile().toPath(), depsString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> getDependencyStrings(Configuration config) {
        return config.getResolvedConfiguration().getFirstLevelModuleDependencies().stream().map(dep -> dep.getModuleGroup() + ":" + dep.getModuleName() + "=" + dep.getModuleVersion()).sorted().distinct().collect(Collectors.toList());
    }
}

