/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.gradle.utils.lazilyconfiguredmapping;

import com.palantir.gradle.utils.lazilyconfiguredmapping.LazyValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.gradle.api.Action;

public final class LazilyConfiguredMapping<K, V, A> {
    private final Supplier<V> valueFactory;
    @GuardedBy(value="this")
    private final List<LazyValues<K, V, A>> values = new ArrayList<LazyValues<K, V, A>>();
    @GuardedBy(value="this")
    private final Map<K, Optional<V>> computedValues = new HashMap<K, Optional<V>>();
    @GuardedBy(value="this")
    private boolean finalized = false;

    public LazilyConfiguredMapping(Supplier<V> valueFactory) {
        this.valueFactory = valueFactory;
    }

    public synchronized void put(LazyValues<K, V, A> lazyValues) {
        this.ensureNotFinalized();
        this.values.add(lazyValues);
    }

    public synchronized void put(K key, Action<V> value) {
        this.ensureNotFinalized();
        this.put((requestedKey, _ignored) -> {
            if (requestedKey.equals(key)) {
                return Optional.of(value);
            }
            return Optional.empty();
        });
    }

    private synchronized void ensureNotFinalized() {
        if (this.finalized) {
            throw new IllegalStateException(String.format("This %s has already been finalized as get() hase been called. No further elements can be added to it", LazilyConfiguredMapping.class.getSimpleName()));
        }
    }

    public synchronized Optional<V> get(K key, A additionalData) {
        this.finalized = true;
        return this.computedValues.computeIfAbsent(key, _ignored -> {
            Object value = this.valueFactory.get();
            AtomicBoolean created = new AtomicBoolean(false);
            this.values.forEach(lazyValues -> lazyValues.compute(key, additionalData).ifPresent(action -> {
                created.set(true);
                action.execute(value);
            }));
            if (created.get()) {
                return Optional.of(value);
            }
            return Optional.empty();
        });
    }
}

