/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;

public abstract class ExecutableTransform
implements TransformAction<TransformParameters.None> {
    private static Logger logger = Logging.getLogger(ExecutableTransform.class);

    @InputArtifact
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(TransformOutputs outputs) {
        File inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
        File outputFile = outputs.file((Object)(inputFile.getName() + ".executable"));
        try {
            Files.copy(inputFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ExecutableTransform.makeFileExecutable(outputFile.toPath());
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to create executable file %s", outputFile.toPath()), e);
        }
    }

    private static void makeFileExecutable(Path pathToExe) {
        try {
            Set<PosixFilePermission> existingPermissions = Files.getPosixFilePermissions(pathToExe, new LinkOption[0]);
            Files.setPosixFilePermissions(pathToExe, Stream.concat(existingPermissions.stream(), Stream.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE)).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to set execute permissions on native-image", e);
        }
    }
}

