/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;

public final class FileUtils {
    public static void delete(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            FileUtils.deleteDirectory(path);
        } else {
            FileUtils.deleteFile(path);
        }
    }

    private static void deleteDirectory(Path dir) {
        try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).forEach(FileUtils::deleteFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete directory", e);
        }
    }

    private static void deleteFile(Path targetPath) {
        try {
            Files.delete(targetPath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to delete path %s", targetPath), e);
        }
    }

    private FileUtils() {
    }
}

