/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Streams;
import com.google.common.collect.TreeRangeSet;
import com.palantir.javaformat.gradle.LineOffsetIterator;
import com.palantir.javaformat.java.FormatterException;
import com.palantir.javaformat.java.FormatterService;
import com.palantir.javaformat.java.Replacement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

final class FormatDiff {
    private static final Pattern SEPARATOR = Pattern.compile("diff --git");
    private static final Pattern FILENAME = Pattern.compile("^\\+\\+\\+ (.+?)/(?<filename>.+)\\n", 8);
    private static final Pattern HUNK = Pattern.compile("^@@.*\\+(?<startLineOneIndexed>\\d+)(,(?<numLines>\\d+))?", 8);

    FormatDiff() {
    }

    public static void formatDiff(Path dirToFormat, FormatterService formatter) throws IOException, InterruptedException {
        String gitOutput = FormatDiff.gitDiff(dirToFormat);
        Path gitTopLevelDir = FormatDiff.gitTopLevelDir(dirToFormat);
        FormatDiff.parseGitDiffOutput(gitOutput).filter(diff -> diff.path.toString().endsWith(".java")).map(diff -> new SingleFileDiff(gitTopLevelDir.resolve(diff.path), diff.lineRanges)).filter(diff -> Files.exists(diff.path, new LinkOption[0])).forEach(diff -> FormatDiff.format(formatter, diff));
    }

    @VisibleForTesting
    static Stream<SingleFileDiff> parseGitDiffOutput(String gitOutput) {
        return Streams.stream((Iterable)Splitter.on((Pattern)SEPARATOR).omitEmptyStrings().split((CharSequence)gitOutput)).flatMap(singleFileDiff -> {
            Matcher filenameMatcher = FILENAME.matcher((CharSequence)singleFileDiff);
            if (!filenameMatcher.find()) {
                System.err.println("Failed to find filename");
                return Stream.empty();
            }
            Path path = Paths.get(filenameMatcher.group("filename"), new String[0]);
            TreeRangeSet lineRanges = TreeRangeSet.create();
            Matcher hunk = HUNK.matcher((CharSequence)singleFileDiff);
            while (hunk.find()) {
                int firstLineOfHunk = Integer.parseInt(hunk.group("startLineOneIndexed")) - 1;
                int hunkLength = Optional.ofNullable(hunk.group("numLines")).map(Integer::parseInt).orElse(1);
                Range rangeZeroIndexed = Range.closedOpen((Comparable)Integer.valueOf(firstLineOfHunk), (Comparable)Integer.valueOf(firstLineOfHunk + hunkLength));
                lineRanges.add(rangeZeroIndexed);
            }
            return Stream.of(new SingleFileDiff(path, (RangeSet<Integer>)lineRanges));
        });
    }

    private static void format(FormatterService formatter, SingleFileDiff diff) {
        String input;
        try {
            input = new String(Files.readAllBytes(diff.path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            System.err.println("Failed to read file " + String.valueOf(diff.path));
            e.printStackTrace(System.err);
            return;
        }
        RangeSet<Integer> charRanges = FormatDiff.lineRangesToCharRanges(input, diff.lineRanges);
        try {
            System.err.println("Formatting " + String.valueOf(diff.path));
            ImmutableList replacements = formatter.getFormatReplacements(input, (Collection)charRanges.asRanges());
            String output = FormatDiff.applyReplacements(input, (Collection<Replacement>)replacements);
            Files.write(diff.path, output.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (FormatterException | IOException e) {
            System.err.println("Failed to format file " + String.valueOf(diff.path));
            e.printStackTrace(System.err);
        }
    }

    private static String gitDiff(Path dir) throws IOException, InterruptedException {
        return FormatDiff.gitCommand(dir, "git", "diff", "-U0", "HEAD", dir.toAbsolutePath().toString());
    }

    private static Path gitTopLevelDir(Path dir) throws IOException, InterruptedException {
        return Paths.get(FormatDiff.gitCommand(dir, "git", "rev-parse", "--show-toplevel"), new String[0]);
    }

    private static String gitCommand(Path dir, String ... args) throws IOException, InterruptedException {
        Process process = new ProcessBuilder(new String[0]).command(args).directory(dir.toFile()).start();
        Preconditions.checkState((boolean)process.waitFor(30L, TimeUnit.SECONDS), (Object)"git diff took too long to terminate");
        Preconditions.checkState((process.exitValue() == 0 ? 1 : 0) != 0, (Object)"Expected return code of 0");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        process.getInputStream().transferTo(baos);
        return new String(baos.toByteArray(), StandardCharsets.UTF_8).trim();
    }

    private static String applyReplacements(String input, Collection<Replacement> replacementsCollection) {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>(replacementsCollection);
        replacements.sort(Comparator.comparing(r -> (Integer)r.getReplaceRange().lowerEndpoint()).reversed());
        StringBuilder writer = new StringBuilder(input);
        for (Replacement replacement : replacements) {
            writer.replace((Integer)replacement.getReplaceRange().lowerEndpoint(), (Integer)replacement.getReplaceRange().upperEndpoint(), replacement.getReplacementString());
        }
        return writer.toString();
    }

    private static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, (Iterator)new LineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet characterRanges = TreeRangeSet.create();
        for (Range lineRange : lineRanges.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lines.size() - 1))).asRanges()) {
            int lineStart = (Integer)lines.get((Integer)lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get((Integer)lineRange.upperEndpoint()) - 1;
            Range range = Range.closedOpen((Comparable)Integer.valueOf(lineStart), (Comparable)Integer.valueOf(lineEnd));
            characterRanges.add(range);
        }
        return characterRanges;
    }

    public static class SingleFileDiff {
        private final Path path;
        private final RangeSet<Integer> lineRanges;

        public SingleFileDiff(Path path, RangeSet<Integer> lineRanges) {
            this.path = path;
            this.lineRanges = lineRanges;
        }

        public String toString() {
            return "SingleFileDiff{path=" + String.valueOf(this.path) + ", lineRanges=" + String.valueOf(this.lineRanges) + "}";
        }
    }
}

