/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.palantir.javaformat.gradle.FileUtils;
import com.palantir.javaformat.gradle.PalantirJavaFormatIdeaPlugin;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class NativeImageAtomicCopy {
    private static Logger logger = Logging.getLogger(PalantirJavaFormatIdeaPlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URI copyToCacheDir(Path src, Path dst) {
        if (Files.exists(dst, new LinkOption[0])) {
            logger.info("Native image at path {} already exists", (Object)dst);
            return dst.toUri();
        }
        Path lockFile = dst.getParent().resolve(String.valueOf(dst.getFileName()) + ".lock");
        try (FileChannel channel = FileChannel.open(lockFile, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            channel.lock();
            if (Files.exists(dst, new LinkOption[0])) {
                logger.info("Native image at path {} already exists", (Object)dst);
                URI uRI2 = dst.toUri();
                return uRI2;
            }
            try {
                Path tempCopyDir = Files.createTempDirectory("tempDir", new FileAttribute[0]);
                Path tmpFile = tempCopyDir.resolve(src.getFileName());
                try {
                    Files.copy(src, tmpFile, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(tmpFile, dst, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException ignored) {
                    Files.move(tmpFile, dst, StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    FileUtils.delete(tempCopyDir);
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            URI uRI = dst.toUri();
            return uRI;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to copy the native image to path %s", dst), e);
        }
    }

    private NativeImageAtomicCopy() {
    }
}

