/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.palantir.javaformat.gradle.ExecutableTransform;
import com.palantir.javaformat.gradle.JavaFormatExtension;
import com.palantir.platform.Architecture;
import com.palantir.platform.GradleOperatingSystem;
import com.palantir.platform.OperatingSystem;
import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Nested;

public abstract class NativeImageFormatProviderPlugin
implements Plugin<Project> {
    static final String NATIVE_CONFIGURATION_NAME = "palantirJavaFormatNative";

    @Nested
    protected abstract GradleOperatingSystem getOs();

    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-provider to the root project");
        Provider operatingSystem = this.getOs().getOperatingSystem();
        String implementationVersion = JavaFormatExtension.class.getPackage().getImplementationVersion();
        rootProject.getConfigurations().register(NATIVE_CONFIGURATION_NAME, conf -> {
            conf.setDescription("Internal configuration for resolving the palantir-java-format native image");
            conf.setVisible(false);
            conf.setCanBeConsumed(false);
            conf.setCanBeResolved(true);
            conf.defaultDependencies(deps -> deps.addAllLater(operatingSystem.map(os -> Collections.singletonList(rootProject.getDependencies().create((Object)String.format("com.palantir.javaformat:palantir-java-format-native:%s:nativeImage-%s_%s@%s", implementationVersion, os.uiName(), Architecture.get().uiName(), NativeImageFormatProviderPlugin.getExtension(os)))))));
            conf.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"executable-nativeImage");
        });
        rootProject.getDependencies().registerTransform(ExecutableTransform.class, transformSpec -> {
            transformSpec.getFrom().attributeProvider(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, operatingSystem.map(NativeImageFormatProviderPlugin::getExtension));
            transformSpec.getTo().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"executable-nativeImage");
        });
    }

    static String getExtension(OperatingSystem operatingSystem) {
        if (operatingSystem.equals((Object)OperatingSystem.WINDOWS)) {
            return "exe";
        }
        return "bin";
    }
}

