/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.palantir.platform.Architecture;
import com.palantir.platform.GradleOperatingSystem;
import com.palantir.platform.OperatingSystem;
import javax.inject.Inject;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Nested;

public abstract class NativeImageSupport {
    @Nested
    protected abstract GradleOperatingSystem getOs();

    @Inject
    protected abstract ProviderFactory getProviderFactory();

    public boolean isNativeImageConfigured() {
        return this.isNativeFlagEnabled() && this.isNativeImageSupported();
    }

    private boolean isNativeImageSupported() {
        return (Boolean)this.getOs().getOperatingSystem().map(os -> os.equals((Object)OperatingSystem.LINUX_GLIBC) || os.equals((Object)OperatingSystem.MACOS) && Architecture.get().equals((Object)Architecture.AARCH64)).get();
    }

    private boolean isNativeFlagEnabled() {
        return (Boolean)this.getProviderFactory().gradleProperty("palantir.native.formatter").map(Boolean::parseBoolean).orElse((Object)false).get();
    }
}

