/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.gradle;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.palantir.gradle.ideaconfiguration.IdeaConfigurationExtension;
import com.palantir.gradle.ideaconfiguration.IdeaConfigurationPlugin;
import com.palantir.javaformat.gradle.NativeImageSupport;
import com.palantir.javaformat.gradle.PalantirJavaFormatProviderPlugin;
import com.palantir.javaformat.gradle.UpdatePalantirJavaFormatIdeaXmlFile;
import com.palantir.javaformat.gradle.UpdateWorkspaceXmlFile;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskProvider;

public abstract class PalantirJavaFormatIdeaPlugin
implements Plugin<Project> {
    private static final String MIN_IDEA_PLUGIN_VERSION = "2.57.0";

    @Nested
    protected abstract NativeImageSupport getNativeImageSupport();

    @Inject
    protected abstract ConfigurationContainer getConfigurations();

    public void apply(Project rootProject) {
        Preconditions.checkState((rootProject == rootProject.getRootProject() ? 1 : 0) != 0, (Object)"May only apply com.palantir.java-format-idea to the root project");
        rootProject.getPlugins().apply(PalantirJavaFormatProviderPlugin.class);
        rootProject.getPluginManager().withPlugin("idea", ideaPlugin -> {
            TaskProvider updatePalantirJavaFormatXml = rootProject.getTasks().register("updatePalantirJavaFormatXml", UpdatePalantirJavaFormatIdeaXmlFile.class, task -> {
                task.getXmlOutputFile().set(rootProject.file((Object)".idea/palantir-java-format.xml"));
                task.getImplementationConfig().from(new Object[]{rootProject.getConfigurations().getByName("palantirJavaFormat")});
                this.maybeGetNativeImplConfiguration().ifPresent(config -> {
                    task.getNativeImageConfig().from(new Object[]{config});
                    task.getNativeImageOutputFile().fileProvider(rootProject.provider(() -> rootProject.getGradle().getGradleUserHomeDir().toPath().resolve("palantir-java-format-caches/").resolve(Paths.get(task.getNativeImageConfig().getSingleFile().toURI()).getFileName().toString()).toFile()));
                });
            });
            TaskProvider updateWorkspaceXml = rootProject.getTasks().register("updateWorkspaceXml", UpdateWorkspaceXmlFile.class, task -> task.getOutputFile().set(rootProject.file((Object)".idea/workspace.xml")));
            StartParameter startParameter = rootProject.getGradle().getStartParameter();
            List<String> updateTasks = Stream.of(updatePalantirJavaFormatXml, updateWorkspaceXml).map(taskProvider -> String.format(":%s", taskProvider.getName())).toList();
            ImmutableList taskNames = ImmutableList.builder().addAll((Iterable)startParameter.getTaskNames()).addAll(updateTasks).build();
            startParameter.setTaskNames((Iterable)taskNames);
        });
        rootProject.getPluginManager().apply(IdeaConfigurationPlugin.class);
        IdeaConfigurationExtension extension = (IdeaConfigurationExtension)rootProject.getExtensions().getByType(IdeaConfigurationExtension.class);
        extension.getExternalDependencies().register("palantir-java-format", dep -> dep.atLeastVersion(MIN_IDEA_PLUGIN_VERSION));
    }

    private Optional<Configuration> maybeGetNativeImplConfiguration() {
        return this.getNativeImageSupport().isNativeImageConfigured() ? Optional.of(this.getConfigurations().getByName("palantirJavaFormatNative")) : Optional.empty();
    }
}

